#include "IdisTDoc.h"

int tdoc_skupina_seq;

void LoadMacros(TDocS& ts, VectorMap<String, String>& macro, Vector<String>& name)
{
	Sql sql;
	sql * Select(ts.ID, ts.NAZEV, ts.LTEXT).From(ts.MACRO).OrderBy(ts.NAZEV);
	while(sql.Fetch()) {
		macro.Add(sql[0], sql[2]);
		name.Add(sql[1]);
	}
}

void TDocDlg::SablonaRefresh()
{
	view.Clear();
	if(sablona.IsCursor()) {
		VectorMap<String, String> macro;
		Vector<String> name;
		LoadMacros(ts, macro, name);
		view.Pick(Expand(String(SQL % Select(ts.TEXT).From(ts.SABLONA)
		                              .Where(ts.SABLONA_SEQ == sablona.GetKey())),
		                 MakeTData(MakeVars(), macro, name)));
	}
}

void TDocDlg::SablonaCursor()
{
	SablonaRefresh();
	if(sablona.IsCursor())
		SablonaChanged();
}

void TDocDlg::Skupina()
{
	sablona.Clear();
	Value x = skupina.GetKey();
	SqlBool wh = ts.SKUPINA_SEQ.Of(ts.SKUPINA) == ts.SKUPINA_SEQ.Of(ts.SABLONA);
	if(!IsNull(x))
		wh = wh && ts.SKUPINA_SEQ.Of(ts.SABLONA) == x;
	Sql sql;
	if(ts.TYP.IsNull()) {
		sql * Select(ts.SABLONA_SEQ, ts.NAZEV.Of(ts.SABLONA))
		      .From(ts.SABLONA, ts.SKUPINA).Where(wh).OrderBy(ts.NAZEV);
		while(sql.Fetch())
			sablona.Add(sql[0], sql[1]);
	}
	else {
		sql * Select(ts.SABLONA_SEQ, ts.NAZEV.Of(ts.SABLONA), ts.TYP)
		      .From(ts.SABLONA, ts.SKUPINA)
		      .Where(wh).OrderBy(ts.NAZEV);
		while(sql.Fetch())
			sablona.Add(sql[0], sql[1], sql[2]);
	}
	sablona.GoBegin();
	tdoc_skupina_seq = skupina.GetKey();
}

void TDocDlg::CreateMode(Ctrl& p)
{
	p.Add(skupina);
	p.Add(sablona);
	p.Add(view);

	Sql sql;
	if(ts.PRISTUP.IsNull()) {
		sql * Select(ts.SKUPINA_SEQ, ts.SNAZEV)
		      .From(ts.SKUPINA).OrderBy(ts.SNAZEV);
		while(sql.Fetch())
			skupina.Add(sql[0], sql[1]);
	}
	else {
		sql * Select(ts.SKUPINA_SEQ, ts.SNAZEV, ts.PRISTUP)
		      .From(ts.SKUPINA).OrderBy(ts.SNAZEV);
		while(sql.Fetch())
			if(IsNull(sql[2]) || UserPristup().Find(sql[2]) >= 0)
				skupina.Add(sql[0], sql[1]);
	}
	skupina.Add(Null, "<vechny>");
	skupina.FindSetCursor(tdoc_skupina_seq);
	if(!skupina.IsCursor())
		skupina.GoBegin();
}

void TDocDlg::EndCreateMode()
{
	skupina.Ctrl::Remove();
	sablona.Ctrl::Remove();
	view.Ctrl::Remove();
}

TDocDlg::TDocDlg(TDocS ts)
:	ts(ts)
{
	skupina.LeftPosZ(4, 188).TopPosZ(4, 144);
	sablona.LeftPosZ(4, 188).VSizePosZ(152, 4);
	view.HSizePosZ(196, 4).VSizePosZ(4, 4);

	skupina.AddKey(ts.SKUPINA_SEQ);
	skupina.AddColumn(ts.SNAZEV, "Skupina");
	skupina.WhenEnterRow = THISBACK(Skupina);

	sablona.AddKey(ts.SABLONA_SEQ);
	sablona.AddColumn(ts.NAZEV, "ablona");
	if(!ts.TYP.IsNull())
		sablona.AddIndex(ts.TYP);
	sablona.WhenCursor = THISBACK(SablonaCursor);
}

String DocSettings;

void LoadDocSettings(TopWindow& win, RichEdit& e)
{
	if(IsNull(DocSettings)) {
		win.Maximize();
		return;
	}
	StringStream ss(DocSettings);
	win.SerializePlacement(ss);
	e.SerializeSettings(ss);
}

void SaveDocSettings(TopWindow& win, RichEdit& e)
{
	StringStream ss;
	win.SerializePlacement(ss);
	e.SerializeSettings(ss);
	DocSettings = ss;
}
