#include "IdisTDoc.h"

VectorMap<String, Value> QtfText(const VectorMap<String, Value>& var)
{
	VectorMap<String, Value> v;
	for(int i = 0; i < var.GetCount(); i++) {
		v.Add(var.GetKey(i), Qtlf(StdFormat(var[i])));
		v.Add(var.GetKey(i) + "_", var[i]);
	}
	return v;
}

RichTxt Expand(const RichTxt& text, const RichStyles& styles,
               const VectorMap<String, NamedText>& map)
{
	RichText r;
	NamedText deftext;
	deftext.text = "****";
	for(int i = 0; i < text.GetPartCount(); i++) {
		if(text.IsPara(i)) {
			RichPara para = text.Get(i, styles);
			RichPara rpara;
			rpara.format = para.format;
			for(int j = 0; j < para.GetCount(); j++) {
				const RichPara::Part& p = para[j];
				if(IsNull(p.format.indexentry))
					rpara.part.Add(p);
				else {
					StringBuffer t;
					String d = map.Get(p.format.indexentry.ToString(), deftext).text;
					t << "[%CS-CZI" << p.format.indexentry.ToString() << "; " << d << ']';
					RichText txt = ParseQTF(t);
					if((txt.GetPartCount() > 1 || txt.GetPartCount() > 0 && txt.IsTable(0))
					   && rpara.GetCount() == 0) {
						for(int i = 0; i < txt.GetPartCount(); i++)
							if(txt.IsPara(i))
								r.Cat(txt.Get(i));
							else {
								RichTable tab(txt.GetTable(i), 1);
								r.CatPick(tab);
							}
						goto norpara;
					}
					else
					if(txt.GetPartCount() && txt.IsPara(0)) {
						RichPara par = txt.Get(0);
						for(int j = 0; j < par.GetCount(); j++) {
							rpara.part.Add(par[j]);
							rpara.part.Top().format = p.format;
						}
					}
				}
			}
			r.Cat(rpara);
		norpara:;
		}
		else {
			RichTable tab(text.GetTable(i), 1);
			Size sz = tab.GetSize();
			for(int q = 0; q < sz.cy; q++)
				for(int j = 0; j < sz.cx; j++) {
					RichTxt h = Expand(tab.Get(q, j), styles, map);
					tab.SetPick(q, j, h);
				}
			r.CatPick(tab);
		}
	}
	return r;
}

RichText Expand(const char *qtf, const VectorMap<String, NamedText>& map)
{
	RichText text = ParseQTF(qtf);
	RichStyles styles;
	styles <<= text.GetStyles();
	return RichText(Expand(text, styles, map), styles);
}

RichPara::CharFormat GetTabParaFormat(const RichTable& tab, const RichTxt& text,
                                      const RichStyles& s)
{
	if(tab.cell.GetCount() && tab.cell[0].GetCount()) {
		const RichTxt& txt = tab.cell[0][0].text;
		if(txt.GetPartCount() && txt.IsPara(0)) {
			RichPara para = txt.Get(0, s);
			return para.GetCount() ? para[0].format : para.format;
		}
	}
	return RichPara::CharFormat();
}

RichTxt Purify(const RichTxt& text, const RichStyles& styles)
{
	RichText r;
	WString di;
	for(int i = 0; i < text.GetPartCount(); i++)
		if(text.IsPara(i)) {
			RichPara para = text.Get(i, styles);
			RichPara rpara;
			rpara.format = para.format;
			if(para.GetCount()) {
				for(int j = 0; j < para.GetCount(); j++) {
					const RichPara::Part& p = para[j];
					if(IsNull(p.format.indexentry)) {
						rpara.part.Add(p);
						di = Null;
					}
					else
					if(p.format.indexentry != di) {
						di = p.format.indexentry;
						rpara.Cat("@", p.format);
					}
				}
				if(rpara.GetCount())
					r.Cat(rpara);
			}
			else {
				if(IsNull(para.format.indexentry)) {
					r.Cat(para);
					di = Null;
				}
				else
					if(para.format.indexentry != di) {
						di = para.format.indexentry;
						rpara.Cat("@", para.format);
						r.Cat(rpara);
					}
			}
		}
		else {
			RichTable tab(text.GetTable(i), 1);
			RichPara::CharFormat f = GetTabParaFormat(tab, text, styles);
			if(IsNull(f.indexentry)) {
				Size sz = tab.GetSize();
				for(int i = 0; i < sz.cy; i++)
					for(int j = 0; j < sz.cx; j++)
						tab.SetPick(i, j, Purify(tab.GetPick(i, j), styles));
				r.CatPick(tab);
				di = Null;
			}
			else
			if(f.indexentry != di) {
				RichPara rpara;
				rpara.Cat("@", f);
				r.Cat(rpara);
				di = f.indexentry;
			}
		}
	DUMP(AsQTF(r));
	return r;
}

RichText Purify(const RichText& text)
{
	RichStyles h;
	h <<= text.GetStyles();
	return RichText(Purify(text, h), h);
}

String MacroExpand(const char *term, const VectorMap<String, String>& macro)
{
	String out;
	String h;
	for(int i = 0; i < 100; i++) {
		bool done = true;
		while(*term)
			if(term[0] == '<' && term[1] == '#') {
				String key;
				term += 2;
				while(term[0] != '#' || term[1] != '>') {
					if(!*term) return out + "<Neukonen makro>";
					key.Cat(*term++);
				}
				term += 2;
				out.Cat(macro.Get(key, Null));
				done = false;
			}
			else {
				if((byte)*term >= ' ')
					out.Cat(*term);
				term++;
			}
		if(done) break;
		h = out;
		out.Clear();
		term = h;
	}
	return out;
}

String ExpandText(const String& text, const VectorMap<String, Value>& var,
                  const VectorMap<String, String>& macro)
{
	ArrayMap<String, EscValue> global;
	StdLib(global);
	StdValueLib(global);
	IdisLib(global);
//	if(ids.lib)
//		(*ids.lib)(global);
	for(int i = 0; i < var.GetCount(); i++)
		global.Add(var.GetKey(i), EscFromStdValue(var[i]));
	return Expand(MacroExpand(text, macro), global, 20000);
}

VectorMap<String, NamedText> MakeTData(const VectorMap<String, Value>& v,
                                       const VectorMap<String, String>& macro,
                                       const Vector<String>& name)
{
	VectorMap<String, NamedText> r;
	VectorMap<String, Value> data = QtfText(v);
	for(int i = 0; i < macro.GetCount(); i++)
		if(!IsNull(name[i]) && !IsNull(macro.GetKey(i))) {
			NamedText& x = r.GetAdd(macro.GetKey(i));
			x.name = name[i];
			x.text = ExpandText(macro[i], data, macro);
		}
	return r;
}
