#include "IdisTDoc.h"

#pragma BLITZ_PROHIBIT

void ExportDocs(const TDocS& ids)
{
	String dir = "C:\\" + ~ids.SABLONA;
	RealizeDirectory(dir);
	int q = 0;
	SQL * Select(ids.ID, ids.MNAZEV, ids.LTEXT).From(ids.MACRO);
	while(SQL.Fetch())
		SaveFile(AppendFileName(dir, AsString(++q) + "@" + (String)SQL[0] + "$" + (String)SQL[1] + ".makro"), SQL[2]);
	SQL * Select(ids.NAZEV.Of(ids.SABLONA), ids.SNAZEV.Of(ids.SKUPINA), ids.TEXT.Of(ids.SABLONA))
	      .From(ids.SABLONA, ids.SKUPINA)
	      .Where(ids.SKUPINA_SEQ.Of(ids.SKUPINA) == ids.SKUPINA_SEQ.Of(ids.SABLONA));
	while(SQL.Fetch())
		SaveFile(AppendFileName(dir, AsString(++q) + "@" + (String)SQL[0] + "$" + (String)SQL[1] + ".sablona"), SQL[2]);
	SQL * Select(NAZEV, TEXT)
	      .From(ids.SABLONA)
	      .Where(IsNull(ids.SKUPINA_SEQ));
	while(SQL.Fetch())
		SaveFile(AppendFileName(dir, AsString(++q) + "@" + (String)SQL[0] + ".sablona"), SQL[1]);
	PromptOK("Export ukonen");
}

String TGetIDName(const char *fn)
{
	String s = ::GetFileTitle(fn);
	int q = s.Find('@');
	if(q >= 0)
		return s.Mid(q + 1);
	return s;
}

void ImportDocs(const TDocS& ids)
{
	if(!PromptYesNo("Importovat sablony?"))
		return;
	String dir = "C:\\" + ~ids.SABLONA;
	SqlSequence& seq = *ids.Seq;
	{
		FindFile ff(AppendFileName(dir, "*.makro"));
		while(ff) {
			Vector<String> w = Split(TGetIDName(ff.GetName()), '$');
			int q = ++seq;
			if(w.GetCount() == 2)
				SQL * Insert(ids.MACRO)
						(ids.MACRO_SEQ, q)
						(ids.ID, w[0])
						(ids.MNAZEV, w[1]);
			else
			if(w.GetCount() == 1)
				SQL * Insert(ids.MACRO)
						(ids.MACRO_SEQ, q)
						(ids.ID, w[0]);
			else {
				Exclamation(ff.GetName());
				return;
			}
			SQL.Execute("update " + ~ids.MACRO + " set " + ~ids.LTEXT + " = ? where " + ~ids.MACRO_SEQ + " = ?",
			            SqlRaw(LoadFile(AppendFileName(dir, ff.GetName()))), q);
			ff.Next();
		}
	}
	VectorMap<String, int> skupina;
	SQL * Select(ids.SNAZEV, ids.SKUPINA_SEQ).From(ids.SKUPINA);
	while(SQL.Fetch())
		skupina.Add(SQL[0], SQL[1]);
	{
		FindFile ff(AppendFileName(dir, "*.sablona"));
		while(ff) {
			Vector<String> w = Split(TGetIDName(ff.GetName()), '$');
			if(w.GetCount() != 2 && w.GetCount() != 1) {
				Exclamation(ff.GetName());
				return;
			}
			int skupina_seq;
			if(w.GetCount() == 1)
				skupina_seq = Null;
			else {
				skupina_seq = skupina.Get(w[1], Null);
				if(IsNull(skupina_seq)) {
					skupina_seq = ++seq;
					SQL * Insert(ids.SKUPINA)(ids.SKUPINA_SEQ, skupina_seq)(ids.SNAZEV, w[1]);
					skupina.Add(w[1], skupina_seq);
				}
			}
			SQL.Execute("insert into " + ~ids.SABLONA + "(" +
			                             ~ids.SABLONA_SEQ + ", " +
			                             ~ids.SKUPINA_SEQ + ", NAZEV, TEXT) "
			            "       values(?, ?, ?, ?)",
			            ++seq, skupina_seq, w[0], SqlRaw(LoadFile(AppendFileName(dir, ff.GetName()))));
			ff.Next();
		}
	}
}
