#include "IdisTDoc.h"
#include <commdlg.h>

#pragma BLITZ_PROHIBIT

struct IsWatermark : RichText::Iterator
{
	bool operator()(int pos, const RichPara& para) {
		return para.format.label == "WATERMARK";
	}
};

void DocPrint::Print(Draw& w, const RichText& text, const Rect& page, int firstpage, int lastpage,
                     int copies, bool collate, bool report)
{
	IsWatermark iwm;
	bool watermark = text.Iterate(iwm);
	RichText watermark_text;
	int wh;
	int ph = Roman(75).Info().GetHeight();
	Size pgsz = page.Size();
	if(watermark) {
		watermark_text = ParseQTF(watermark_qtf);
		wh = watermark_text.GetHeight(pgsz.cx) + ph;
	}
	firstpage = max(0, firstpage);
	int lpage = text.GetHeight(page).page;
	lastpage = min(lastpage, text.GetHeight(page).page);
	PrintPageDraw pw(w);
	Size mmsz = w.GetPageMMs();
	int x = (6000 * mmsz.cx / 254 - pgsz.cx) / 2;
	int y = (6000 * mmsz.cy / 254 - pgsz.cy) / 2;
	if(report)
		x = y = 0;
	for(int c = 0; c < (collate ? copies : 1); c++)
		for(int i = firstpage; i <= lastpage; i++)
			for(int c = 0; c < (collate ? 1 : copies); c++) {
				w.StartPage();
				PaintInfo paintinfo;
				paintinfo.indexentry = Null;
				paintinfo.hyperlink = Null;
				if(watermark) {
					pw.SetPage(0);
					paintinfo.top = PageY(0, 0);
					paintinfo.bottom = PageY(1, 0);
					w.Offset(x, 6000 * mmsz.cy / 254 - wh);
					watermark_text.Paint(pw, page, paintinfo);
					w.End();
					String pg = Format("%d / %d", i + 1, lpage + 1);
					Size psz = GetTextSize(pg, Roman(75));
					w.DrawText(x + (pgsz.cx - psz.cx) / 2, 6000 * mmsz.cy / 254 - psz.cy,
					           pg, Roman(75), Gray);
				}
				w.Offset(x, y);
				pw.SetPage(i);
				paintinfo.top = PageY(i, 0);
				paintinfo.bottom = PageY(i + 1, 0);
				text.Paint(pw, page, paintinfo);
				w.End();
				if(!IsNull(header) && i)
					pw.Page(i).DrawText(x, y + pgsz.cy + 100, header, Arial(90).Italic());
				if(!IsNull(footer) && lpage && !watermark) {
					String n = Format(footer, i + 1, lpage + 1);
					Size nsz = GetTextSize(n, Arial(90).Italic());
					pw.Page(i).DrawText(
						x + pgsz.cx - nsz.cx, y + pgsz.cy + 100,
						n, Arial(90).Italic());
				}
				w.EndPage();
			}
}

void DocPrint::Print(HDC hdc, const RichText& text, const Rect& page,
                     int firstpage, int lastpage, int copies, bool collate,
                     const char *name)
{
	PrintDraw w(hdc, name ? (const char *)name : (const char *)GetExeTitle());
	Print(w, text, page, firstpage, lastpage, copies, collate);
}


bool DocPrint::Print(const RichText& text, const Rect& page, int currentpage)
{
	PRINTDLG dlg;
	memset(&dlg, 0, sizeof(dlg));
	dlg.lStructSize = sizeof(dlg);
	dlg.hwndOwner = ::GetActiveWindow();
	dlg.Flags = PD_ALLPAGES|PD_DISABLEPRINTTOFILE|PD_NOSELECTION|PD_RETURNDC|
		        PD_HIDEPRINTTOFILE;
	dlg.nFromPage = currentpage + 1;
	dlg.nToPage = currentpage + 1;
	dlg.nMinPage = 1;
	dlg.nMaxPage = text.GetHeight(page).page + 1;
	if(!PrintDlg(&dlg)) return false;
	if(!(dlg.Flags & PD_PAGENUMS)) {
		dlg.nFromPage = dlg.nMinPage;
		dlg.nToPage = dlg.nMaxPage;
	}
	Print(dlg.hDC, text, page, dlg.nFromPage - 1, dlg.nToPage - 1, dlg.nCopies,
	      dlg.Flags & PD_COLLATE, "Dokument");
	return true;
}

void DocPrint::Preview(const RichText& text, const Rect& page)
{
	NewReport report;
	int n = text.GetHeight(page).page;
	for(int i = 0; i <= n; i++)
		Print(report.Page(i), text, page, i, i, 1, false, true);
	Perform(report);
}
