#include "IdisTDoc.h"

struct SablonaDlg : WithSoSablonaLayout<TopWindow> {
	VectorMap<String, NamedText> data;
	EditString                   nazev, snazev;
	Button                       edit;

	void SablonaCursor();
	void Edit();

	typedef SablonaDlg CLASSNAME;

	SablonaDlg();
};

void SablonaDlg::SablonaCursor()
{
	view.Clear();
	edit.Disable();
	if(sablona.IsCursor()) {
		view.Pick(Expand(String(SQL % Select(TEXT).From(SO_SABLONA).Where(SABLONA_SEQ == sablona.GetKey())), data));
		edit.Enable();
	}
}

void SablonaDlg::Edit()
{
	if(!sablona.IsCursor())
		return;
	TDoc ew;
	ew.data <<= data;
	ew.editor <<= ~view;
	if(!ew.Execute())
		return;
	SQL.Execute("update SO_SABLONA set TEXT = ? where SABLONA_SEQ = ?",
	            SqlRaw(ew.GetPurifiedText()), sablona.GetKey());
	SablonaCursor();
}

SablonaDlg::SablonaDlg()
{
	CtrlLayout(*this, "ablony");
	skupina.SetTable(SO_SABLONA_SKUPINA);
	skupina.AddKey(SKUPINA_SEQ).InsertValue(SeqSo);
	skupina.AddColumn(NAZEV, "Skupina").Edit(nazev);
	skupina.Appending().Removing();

	sablona.SetTable(SO_SABLONA);
	sablona.AddKey(SABLONA_SEQ).InsertValue(SeqSo);
	sablona.Join(skupina);
	sablona.AddColumn(NAZEV, "ablona").Edit(snazev);
	sablona.Appending().Removing();
	sablona.WhenCursor = THISBACK(SablonaCursor);

	skupina.Query();

	view.Add(edit.SetLabel("Opravit").RightPos(0, 64).BottomPos(0, 24));
	edit <<= THISBACK(Edit);
}
