#include "IdisTDoc.h"

struct MacroDlg : public WithMacroLayout<TopWindow>, TDocS {
	EditString   id, nazev;
	Button       edit, buttonvar;
	TimeCallback tm;
	PopUpTable   textvar;

	VectorMap<String, String>       macros;
	const VectorMap<String, Value>& data;

	void LoadMacros()
	{
		Sql sql;
		sql * Select(ID, LTEXT).From(MACRO);
		while(sql.Fetch())
			macros.Add(sql[0], sql[1]);
	}

	void Edit()
	{
		TopWindow win;
		RichEditWithToolBar editor;
		win.Add(editor.SizePos());
		win.Zoomable().Sizeable();
		win.Maximize();
		win.Open();
		editor <<= ~ltext;
		win.Run();
		if(PromptYesNo("Uloit proveden zmny?")) {
			ltext <<= AsQTF(editor.Get(),
			                CHARSET_WIN1250, QTF_BODY|QTF_CRLF|QTF_NOCHARSET|QTF_NOSTYLES|QTF_NOLANG);
			RefreshView();
		}
	}

	void RefreshView()
	{
		if(macro.IsCursor())
			macros.GetAdd(macro.Get(ID)) = ~ltext;
		view <<= ExpandText(~ltext, QtfText(data), macros);
	}

	bool SaveMacro() {
		SQL.Execute("update " + ~MACRO + " set " + ~LTEXT + " = ? where " + ~MACRO_SEQ + " = ?",
		            SqlRaw((String)~ltext), macro.GetKey());
		ShowError(SQL);
		macros.GetAdd(macro.Get(ID)) = ~ltext;
		return true;
	}

	void EnterMacro()
	{
		ltext.Clear();
		if(macro.IsCursor()) {
			String s = SQL % Select(LTEXT).From(MACRO).Where(MACRO_SEQ == macro.GetKey());
			ltext <<= s;
		}
		RefreshView();
	}

	void SelectText()
	{
		if(textvar.IsCursor()) {
			ltext.Paste(("<:" + (String)textvar.GetKey() + ":>").ToWString());
			RefreshView();
		}
	}

	void DropId()
	{
		textvar.PopUp(&ltext, ltext.GetSize().cx);
	}

	typedef MacroDlg CLASSNAME;

	MacroDlg(const TDocS& ids, const VectorMap<String, Value>& data)
	:	data(data) {
		*(TDocS *)this = ids;

		LoadMacros();

		CtrlLayout(*this, "Makra");
		view.Add(edit.SetLabel("Opravit").RightPos(0, 64).BottomPos(0, 24));
		macro.SetTable(MACRO);
		macro.AddKey(MACRO_SEQ).InsertValue(*Seq);
		macro.AddColumn(ID, "ID", 1).Edit(id);
		macro.AddColumn(MNAZEV, "Nzev", 2).Edit(nazev);
		macro.Appending().Removing();
		macro.SetOrderBy(ID);
		macro.WhenEnterRow = THISBACK(EnterMacro);
		macro.WhenAcceptRow = THISBACK(SaveMacro);
		ltext <<= callback2(&tm, &TimeCallback::KillSet, 300, THISBACK(RefreshView));
		macro.Query();

		ltext.Add(buttonvar.BottomPos(0, 16).RightPos(0, 16));
		buttonvar.EdgeStyle().SetLabel("ID");
		buttonvar <<= THISBACK(DropId);

		textvar.WhenSelect = THISBACK(SelectText);

		edit <<= THISBACK(Edit);

		textvar.AddColumn("", 1);
		textvar.AddColumn("", 1);
		textvar.NoHeader();
		textvar.HeaderTab(0).SetMargin(0);
		textvar.MouseMoveCursor();
		textvar.NoGrid();
		textvar.AutoHideSb();
		textvar.SetLineCy(Draw::GetStdFontCy());
		textvar.AddIndex();
		VectorMap<String, Value> vars = QtfText(data);
		for(int i = 0; i < vars.GetCount(); i++)
			textvar.Add(vars.GetKey(i), vars[i]);
		textvar.Sort(0);
	}
};

void EditMacros(const TDocS& ids, const VectorMap<String, Value>& data)
{
	MacroDlg dlg(ids, data);
	dlg.Run();
}
