#include "IdisTDoc.h"

struct SablonaDlg : WithSablonyLayout<TopWindow>, TDocS {
	VectorMap<String, NamedText> data;
	EditString                   nazev, snazev;
	Button                       edit;

	void SablonaCursor();
	void Edit();

	typedef SablonaDlg CLASSNAME;

	void NewSkupina();
	void RenameSkupina();
	void RemoveSkupina();
	void New();
	void NewAs();
	void Rename();
	void Remove();
	void Move();
	void SkupinaCursor();

	SablonaDlg(const TDocS& ids);
};

void SablonaDlg::SablonaCursor()
{
	view.Clear();
	edit.Disable();
	if(sablona.IsCursor()) {
		view.Pick(Expand(String(SQL % Select(TEXT).From(SABLONA).Where(SABLONA_SEQ == sablona.GetKey())), data));
		edit.Enable();
	}
}

void SablonaDlg::Edit()
{
	if(!sablona.IsCursor())
		return;
	TDoc ew;
	ew.data <<= data;
	ew.editor <<= ~view;
	if(!ew.Execute())
		return;
	SQL.Execute("update " + ~SABLONA + " set " + ~TEXT + " = ? where " + ~SABLONA_SEQ + " = ?",
	            SqlRaw(ew.GetPurifiedText()), sablona.GetKey());
	SablonaCursor();
}

void SablonaDlg::NewSkupina()
{
	String txt;
	if(EditText(txt, "Nov skupina", "Nzev")) {
		int q = ++*Seq;
		SQL * Insert(SKUPINA)(SKUPINA_SEQ, q)(SNAZEV, txt);
		skupina.Query();
		skupina.FindSetCursor(q);
	}
}

void SablonaDlg::RenameSkupina()
{
	if(!skupina.IsCursor())
		return;
	String txt = skupina.Get(SNAZEV);
	if(EditText(txt, "Pejmenovat skupinu", "Nzev")) {
		int q = skupina.GetKey();
		SQL * SqlUpdate(SKUPINA)(SNAZEV, txt).Where(SKUPINA_SEQ == q);
		skupina.Query();
		skupina.FindSetCursor(q);
	}
}

void SablonaDlg::RemoveSkupina()
{
	if(!skupina.IsCursor())
		return;
	if(!PromptYesNo("Pejete si smazat skupinu vetn ablon?"))
		return;
	int q = skupina.GetKey();
	SQL * Delete(SABLONA).Where(SKUPINA_SEQ == q);
	SQL * Delete(SKUPINA).Where(SKUPINA_SEQ == q);
	skupina.Query();
}

void SablonaDlg::New()
{
	String txt;
	if(skupina.IsCursor() && EditText(txt, "Nov ablona", "Nzev")) {
		int q = ++*Seq;
		SQL * Insert(SABLONA)(SKUPINA_SEQ, skupina.GetKey())(SABLONA_SEQ, q)(NAZEV, txt);
		sablona.Query();
		sablona.FindSetCursor(q);
		Edit();
	}
}

void SablonaDlg::NewAs()
{
	String txt;
	if(skupina.IsCursor() && EditText(txt, "Nov ablona", "Nzev")) {
		int q = ++*Seq;
		SQL * Insert(SABLONA)(SKUPINA_SEQ, skupina.GetKey())(SABLONA_SEQ, q)(NAZEV, txt);
		String qtf = ~view;
		sablona.Query();
		sablona.FindSetCursor(q);
		view <<= qtf;
		Edit();
	}
}

void SablonaDlg::Rename()
{
	if(!sablona.IsCursor())
		return;
	String txt = sablona.Get(NAZEV);
	if(skupina.IsCursor() && EditText(txt, "Pejmenovat ablonu", "Nzev")) {
		int q = sablona.GetKey();
		SQL * SqlUpdate(SABLONA)(NAZEV, txt).Where(SABLONA_SEQ == q);
		sablona.Query();
		sablona.FindSetCursor(q);
	}
}

void SablonaDlg::Remove()
{
	if(!sablona.IsCursor())
		return;
	if(!PromptYesNo("Pejete si smazat ablonu?"))
		return;
	int q = sablona.GetKey();
	SQL * Delete(SABLONA).Where(SABLONA_SEQ == q);
	sablona.Query();
}

void SablonaDlg::Move()
{
	WithSkupinaListLayout<TopWindow> d;
	CtrlLayoutOKCancel(d, "Pesunout do skupiny..");
	d.list.AddKey();
	d.list.AddColumn("Skupina");
	Sql sql;
	sql * Select(SKUPINA_SEQ, SNAZEV).From(SKUPINA).OrderBy(SNAZEV);
	while(sql.Fetch())
		d.list.Add(sql[0], sql[1]);
	d.list.GoBegin();
	if(d.Run() != IDOK || !d.list.IsCursor())
		return;
	int sq = d.list.GetKey();
	int q = sablona.GetKey();
	SQL * SqlUpdate(SABLONA)(SKUPINA_SEQ, sq).Where(SABLONA_SEQ == q);
	skupina.Query();
	skupina.FindSetCursor(sq);
	sablona.FindSetCursor(q);
}

void SablonaDlg::SkupinaCursor()
{
	bool b = false;
	if(PRISTUP.IsNull())
		b = true;
	else
		if(skupina.IsCursor()) {
			String q = skupina.Get(PRISTUP);
			b = IsNull(q) || UserPristup().Find(q) >= 0;
		}
	srename.Enable(b);
	sremove.Enable(b);
	sablona.Enable(b);
	create.Enable(b);
	createas.Enable(b);
	rename.Enable(b);
	remove.Enable(b);
	move.Enable(b);
	pristup.Enable(b);
	typ.Enable(b);
	view.Enable(b);
	view.Show(b);
	edit.Enable(b);
}

SablonaDlg::SablonaDlg(const TDocS& ids)
{
	CtrlLayout(*this, "ablony");

	*(TDocS *)this = ids;

	skupina.SetTable(SKUPINA);
	skupina.AddKey(SKUPINA_SEQ).InsertValue(*Seq);
	skupina.AddColumn(SNAZEV, "Skupina").Edit(snazev);
	screate <<= THISBACK(NewSkupina);
	srename <<= THISBACK(RenameSkupina);
	sremove <<= THISBACK(RemoveSkupina);
	skupina.Appending().Removing();
	skupina.SetOrderBy(SNAZEV);

	pristup_lbl.Hide();
	pristup.Hide();
	if(!PRISTUP.IsNull()) {
		pristup_lbl.Show();
		pristup.Show();
		skupina.AddCtrl(PRISTUP, pristup);
		const Index<String>& p = UserPristup();
		pristup.Add(Null, "<vichni>");
		for(int i = 0; i < p.GetCount(); i++)
			pristup.Add(p[i]);
	}

	skupina.WhenCursor = THISBACK(SkupinaCursor);

	sablona.SetTable(SABLONA);
	sablona.Join(skupina);
	sablona.AddKey(SABLONA_SEQ).InsertValue(*Seq);
	sablona.AddColumn(NAZEV, "ablona");
	sablona.SetOrderBy(NAZEV);
	sablona.WhenLeftDouble = THISBACK(Edit);
	create <<= THISBACK(New);
	createas <<= THISBACK(NewAs);
	rename <<= THISBACK(Rename);
	remove <<= THISBACK(Remove);
	move <<= THISBACK(Move);

	typ.Hide();
	if(!TYP.IsNull()) {
		typ.Show();
		sablona.AddCtrl(TYP, typ);
		for(int i = 0; i < typlist.GetCount(); i++)
			typ.Add(typlist.GetKey(i), typlist[i]);
	}

	sablona.Appending().Removing();
	sablona.WhenCursor = THISBACK(SablonaCursor);

	view.Add(edit.SetLabel("Opravit").RightPos(0, 64).BottomPos(0, 24));
	edit <<= THISBACK(Edit);

	skupina.Query();
}

void EditSablony(const TDocS& ids, const VectorMap<String, NamedText>& vars) {
	SablonaDlg dlg(ids);
	dlg.data <<= vars;
	dlg.SablonaCursor();
	dlg.Run();
}
