#include "IdisTDoc.h"

struct SaveSablonaDlg : public WithSaveSablonaLayout<TopWindow>, TDocS {
	String                       text;
	VectorMap<String, NamedText> data;
	Value                        typ;

	void New() {
		if(skupina.IsCursor()) {
			String nazev;
			if(EditText(nazev, "Nov ablona", "Nzev")) {
				int q = ++*Seq;
				SQL * Insert(SABLONA)
						(SABLONA_SEQ, q)
						(SKUPINA_SEQ, skupina.GetKey())
						(NAZEV, nazev)
				;
				if(!TYP.IsNull())
					SQL * SqlUpdate(SABLONA)(TYP, typ).Where(SABLONA_SEQ == q);
				SQL.Execute("update " + ~SABLONA + " set " + ~TEXT + " = ? where " + ~SABLONA_SEQ + " = ?",
				             SqlRaw(text), q);
				Break();
			}
		}
	}

	void Save() {
		if(sablona.IsCursor() && PromptYesNo("Opravdu si pejete pepsat aktuln ablonu?")) {
			SQL.Execute("update " + ~SABLONA + " set " + ~TEXT + " = ? where " + ~SABLONA_SEQ + " = ?",
			             SqlRaw(text), sablona.GetKey());
			Break();
		}
	}

	void SablonaCursor() {
		view.Clear();
		if(sablona.IsCursor())
			view.Pick(Expand(String(SQL % Select(TEXT).From(SABLONA).Where(SABLONA_SEQ == sablona.GetKey())), data));
	}

	typedef SaveSablonaDlg CLASSNAME;

	SaveSablonaDlg(const TDocS& ids) {
		CtrlLayoutCancel(*this, "ablony");
		*(TDocS *)this = ids;
		skupina.SetTable(SKUPINA);
		skupina.AddKey(SKUPINA_SEQ).InsertValue(*Seq);
		skupina.AddColumn(NAZEV, "Skupina");
		skupina.SetOrderBy(NAZEV);

		sablona.SetTable(SABLONA);
		sablona.AddKey(SABLONA_SEQ).InsertValue(*Seq);
		sablona.Join(skupina);
		sablona.AddColumn(NAZEV, "ablona");
		sablona.WhenCursor = THISBACK(SablonaCursor);
		sablona.SetOrderBy(NAZEV);

		skupina.Query();

		insert <<= THISBACK(New);
		save <<= THISBACK(Save);
	}
};

void SaveSablona(const String& text, const TDocS& ids, const VectorMap<String, NamedText>& data,
                 Value typ)
{
	SaveSablonaDlg dlg(ids);
	dlg.typ = typ;
	dlg.text = text;
	dlg.data <<= data;
	dlg.Run();
}
