/*
** $Id: linit.c,v 1.14.1.1 2007/12/27 13:02:25 roberto Exp $
** Initialization of libraries for lua.c
** See Copyright Notice in lua.h
*/


#define linit_c
#define LUA_LIB

#include "lua.h"

#include "lualib.h"
#include "lauxlib.h"

NAMESPACE_LUA_BEGIN

static const luaL_Reg lualibs[] = {
  {"", luaopen_base},
  {LUA_LOADLIBNAME, luaopen_package},
  {LUA_TABLIBNAME, luaopen_table},
  {LUA_IOLIBNAME, luaopen_io},
  {LUA_OSLIBNAME, luaopen_os},
  {LUA_STRLIBNAME, luaopen_string},
  {LUA_MATHLIBNAME, luaopen_math},
  {LUA_DBLIBNAME, luaopen_debug},
#if LUA_WIDESTRING
  {LUA_WSTRLIBNAME, luaopen_wstring},
#endif /* LUA_WIDESTRING */
  {NULL, NULL}
};

#if LUAPLUS_INCLUDE_STANDARD_LIBRARY
extern void LuaPlus_ScriptFunctionsRegister(struct lua_State* L);
#endif

LUALIB_API void luaL_openlibs (lua_State *L) {
  const luaL_Reg *lib = lualibs;
  for (; lib->func; lib++) {
    lua_pushcfunction(L, lib->func);
    lua_pushstring(L, lib->name);
    lua_call(L, 1, 0);
  }

#if LUAPLUS_INCLUDE_STANDARD_LIBRARY
  LuaPlus_ScriptFunctionsRegister(L);
#endif
}

NAMESPACE_LUA_END
