#include <CtrlLib/CtrlLib.h>
using namespace Upp;

template <class T>
class WithMinMaxSize : public T {
	Size minsize, maxsize;
public:
	WithMinMaxSize() : minsize(Null), maxsize(Null) {}
	void SetMinSize(Size min) 		{ minsize = min; }
	void SetMaxSize(Size max) 		{ maxsize = max; }
	virtual Size GetMinSize() const { return Nvl(minsize, T::GetMinSize()); }
	virtual Size GetMaxSize() const { return Nvl(maxsize, T::GetMaxSize()); }
};
typedef WithMinMaxSize<ParentCtrl> LayoutCtrl;

class ScrollContainer : public ParentCtrl
{
	ScrollBars scroll;
	int vspace;
	Ctrl *first;
	
	void OnScroll();
	Size BestSize(Ctrl *c, int cx) const;
public:
	ScrollContainer();
	virtual void Layout();
	
	ScrollContainer &VerticalSpacing(int space) { vspace = space; Layout(); }
};

ScrollContainer::ScrollContainer()
: vspace(0)
{
	AddFrame(scroll.AutoHide());
	scroll.WhenScroll = callback(this, &ScrollContainer::OnScroll);
	first = GetLastChild();
}

void ScrollContainer::OnScroll()
{
	if (!first) return;
	int cx = GetSize().cx;
	Point tl(-scroll.GetX(), -scroll.GetY());
	for (Ctrl *c = first->GetNext(); c; c = c->GetNext()) {
		Size best = BestSize(c, cx);
		c->SetRect(tl.x, tl.y, best.cx, best.cy);
		tl.y += best.cy + vspace;
	}
}

Size ScrollContainer::BestSize(Ctrl *c, int cx) const
{
	Size cmin = c->GetMinSize();
	Size cmax = c->GetMaxSize();
	// If minimum size exceeds width, choose min
	// else if max size fits, choose max
	// otherwise scale to fit available space
	return (cmin.cx > cx) ? cmin : (cmax.cx < cx ? cmax : 
			 Size(cx, cmin.cy + iscale(cmax.cy - cmin.cy, cx - cmin.cx, cmax.cx - cmin.cx)));
}

void ScrollContainer::Layout()
{
	static bool blocklayout = false;
	if (!first || blocklayout) return;	
	
	Size total(0, 0);
	Size sz = GetSize();
	BiVector<Size> ctrlbest;
	
	// Count children
	int cnt = 0;
	for (Ctrl *c = first->GetNext(); c; c = c->GetNext())
		cnt++;
	ctrlbest.Reserve(cnt);
	// Find maximum width, total height, and cache best sizes for later
	for (Ctrl *c = first->GetNext(); c; c = c->GetNext()) {
		Size b = BestSize(c, sz.cx);
		total.cx = max(b.cx, total.cx);
		total.cy += b.cy;
		ctrlbest.AddTail(b);
	}
	// Add spacing
	total.cy += vspace * (ctrlbest.GetCount()-1);
	// Configure scroll bars
	blocklayout = true; // Prevent stack overflow
	scroll.SetTotal(total);
	scroll.SetPage(sz);
	if (sz.cx < total.cx || sz.cy < total.cy)
		// Page size may have changed
		scroll.SetPage(scroll.GetReducedViewSize());
	blocklayout = false;
	
	// Finally set Ctrl positions
	Point tl(-scroll.GetX(), -scroll.GetY());
	for (Ctrl *c = first->GetNext(); c; c = c->GetNext()) {
		c->SetRect(Rect(tl, ctrlbest.Head()));
		tl.y += ctrlbest.Head().cy + vspace;
		ctrlbest.DropHead();
	}	
}

// Dummy 
struct DummyColorPane : public ParentCtrl {
	Button fetch_color;
};
struct DummyProgressPane : public ParentCtrl {
	Progress pi;
};

// Run
GUI_APP_MAIN
{
	TopWindow wnd;
	ScrollContainer cont;
	WithProgressLayout< WithMinMaxSize<DummyProgressPane> > pane_a;
	WithCommentLayout<LayoutCtrl> pane_b;
	WithSimpleSelectLayout<LayoutCtrl> pane_c;
	WithFileSelectorLayout<LayoutCtrl> pane_d;
	WithPaletteLayout< WithMinMaxSize<DummyColorPane> > pane_e;
	WithPalCtrlSizeLayout<LayoutCtrl> pane_f;
	WithKeysLayout<LayoutCtrl> pane_g;
	WithPrinterLayout<LayoutCtrl> pane_h;
	
	CtrlLayout(pane_a);
	CtrlLayout(pane_b);
	CtrlLayout(pane_c);
	CtrlLayout(pane_d);
	CtrlLayout(pane_e);
	CtrlLayout(pane_f);
	CtrlLayout(pane_g);
	CtrlLayout(pane_h);
	pane_a.AddFrame(BlackFrame());
	pane_b.AddFrame(BlackFrame());
	pane_c.AddFrame(BlackFrame());
	pane_d.AddFrame(BlackFrame());
	pane_e.AddFrame(BlackFrame());
	pane_f.AddFrame(BlackFrame());
	pane_g.AddFrame(BlackFrame());
	pane_h.AddFrame(BlackFrame());
		
	wnd.Add(cont.SizePos());
	cont << pane_h;// << pane_b << pane_c << pane_d << pane_e << pane_f 
		 //<< pane_g << pane_a;	
	 
	wnd.Sizeable();
	wnd.SetRect(100, 100, 500, 200);
	wnd.Run();
}
