#include <CtrlLib/CtrlLib.h>
#include <SqlCtrl/SqlArray.cpp>
#include <SqlCtrl/SqlDetail.cpp>
#include <plugin/Sqlite3/Sqlite3.h>

#define LAYOUTFILE <EzellApp4/EzellApp4.lay>
#include <CtrlCore/lay.h>


class EzellApp4 : public WithEzellApp4Layout<TopWindow> {
	WithListLayout<ParentCtrl> list;
	WithDetailLayout<ParentCtrl> detail;
	// The SQLite session
	Sqlite3Session session;

	// For editing
	EditDate editDate;
	EditString editDesc;
	EditString editCost;
	
public:
	typedef EzellApp4 CLASSNAME;
	void SwitchView();
	void CrossUpdate(int);
	EzellApp4();
};

EzellApp4::EzellApp4()
{
	// Setup the layouts
	CtrlLayout(*this, "Bean Heat and Air- Customer Files");
	CtrlLayout(list);
	CtrlLayout(detail);
	
	Sizeable();
	Zoomable();
	
	// Tell tab control what layouts to use
	tab.Add(list, "Customers");
	tab.Add(detail, "Details");
	
	// Log SQL Errors
	session.LogErrors(true);
	
	// Open the database
	if(!session.Open(ConfigFile("simple2.db"))) {
		LOG("Can't create or open database file\n");
		return;
	}else{
		LOG("I think we opened OK\n");
	}
	
	// Kinda dumb that we have to do this
	// isn't there a better way?
	SqlId JOBID("JOBID");
	SqlId NAME("NAME");
	SqlId CUSTOMER_ID("CUSTOMER_ID");
	
	// Setup primary customer list
	list.CListView.SetSession(session);
	list.CListView.SetTable("CUSTOMERS");
	list.CListView.AddColumn("ID","Id");
	list.CListView.HeaderObject().HideTab(0);
	list.CListView.AddColumn("NAME","Name");
	list.CListView.AddColumn("ADDRESS","Address");
	list.CListView.AddColumn("CSZ","City, State Zip");
	list.CListView.AddColumn("PHONE1","Phone 1");
	list.CListView.SetOrderBy(NAME);
	list.CListView.Query();
	list.CListView.WhenLeftDouble = THISBACK(SwitchView);
	list.CListView.AddCtrl("NAME",list.strName1);
	
	// Setup details area (work in progress)
	// Hopefully not needed
	detail.theDetails.SetSession(session);
	detail.theDetails.SetTable("CUSTOMERS");
	detail.theDetails.Add("NAME", detail.strName);
	detail.theDetails.Add("ADDRESS", detail.strAddress);
	detail.theDetails.Add("CSZ", detail.strCSZ);
	detail.theDetails.Join("ID",list.CListView);
	
	// Setup jobs subform
	detail.detailList.SetSession(session);
	detail.detailList.SetTable("JOBS");
	detail.detailList.AddColumn("JOBID","Id");
	detail.detailList.HeaderObject().HideTab(0);
	detail.detailList.AddColumn("DONEDATE","Date").Edit(editDate);
	detail.detailList.AddColumn("DESCRIPTION","Description").Edit(editDesc);
	detail.detailList.AddColumn("COST","Cost").Edit(editCost);
	detail.detailList.SetOrderBy(JOBID);
	detail.detailList.StdBar(detail.myMenu);
	detail.detailList.Join(CUSTOMER_ID,list.CListView);
	detail.detailList.Removing().Appending();
}

void EzellApp4::SwitchView()
{
	tab.GoNext();
}

void EzellApp4::CrossUpdate(int i)
{
	// In progress
	PromptOK("Yea, OK");
	list.CListView.Refresh();
}

GUI_APP_MAIN
{
	EzellApp4().Run();
}

