#include "FastMemoryPool.h"
#include <intrin.h>

NAMESPACE_UPP

bool AtomicValue::TrySetIfEqual(long set, long check)
{
	return _InterlockedCompareExchange(&value, set, check) == check;
}

void AtomicValue::SetIfEqual(long set, long check)
{
	while (!TrySetIfEqual(set, check));
}

int AtomicValue::GetIfNotEqualAndSet(long check)
{
	int res;
	do
	{
		res = value;
	}
	while (res == check || !TrySetIfEqual(check, res));
	return res;
}

bool AtomicValue::TryIncInRange(long max)
{
	long cur = value;
	long next = cur + 1;
	if (next == max)
		next = 0;
	return TrySetIfEqual(next, cur);
}

void AtomicValue::IncInRange(long max)
{
	while (!TryIncInRange(max));
}

long AtomicValue::IncInRangeRetPrev(long max)
{
	long cur, next;
	do
	{
		cur = value;
		next = cur + 1;
		if (next == max)
			next = 0;
	}
	while (!TrySetIfEqual(next, cur));
	return cur;
}

bool AtomicValue::TryMark()
{
	return TrySetIfEqual(1, 0);
}

void AtomicValue::Mark()
{
	while (!TryMark());
}

bool AtomicValue::TryUnmark()
{
	return TrySetIfEqual(0, 1);
}

void AtomicValue::Unmark()
{
	while (!TryUnmark());
}

END_UPP_NAMESPACE

