template<typename T>
struct MemoryPool : NoCopy
{
	MemoryPool()				{}
	MemoryPool(int size)		{ SetCount(size); }
	
	void SetCount(int size)		{ data.SetCount(size); }
	T& Create();
	void Destroy(T& t);
	
private:
	struct Data : Moveable<Data>
	{
		AtomicValue occupied;
		BytesHolder<T> holder;
	};

	AtomicValue counter;
	Vector<Data> data;
};

template<typename T>
T& MemoryPool<T>::Create()
{
	int i;
	do
	{
		i = counter;
		counter.IncInRange(data.GetCount());
	} while (!data[i].occupied.TryMark());
	T& t = data[i].holder.Get();
	::new(&t) T();
	return t;
}

template<typename T>
void MemoryPool<T>::Destroy(T& t)
{
	t.~T();
	int i = (Data*) &t - (Data*) &data.Begin()->holder.Get();
	data[i].occupied.TryUnmark();	// no need to check
}

