template<typename T>
struct MemoryPoolFast : NoCopy
{
	MemoryPoolFast()				{}
	MemoryPoolFast(int size)		{ SetCount(size); }
	
	void SetCount(int size);
	int GetCount() const			{ return freeIndex.GetCount(); }
	T& Create();
	void Destroy(T& t);
	
private:
	static const int free = -1;
	
	AtomicValue counterRemove;	// refers to value to be extracted
	AtomicValue counterAdd;		// refers to inserted value
	Vector<BytesHolder<T> > data;
	Vector<AtomicValue> freeIndex;
};

template<typename T>
void MemoryPoolFast<T>::SetCount(int size)
{
	data.SetCount(size);
	freeIndex.SetCount(size);
	for (int i = 0; i < size; ++ i)
		freeIndex[i] = i;
}

template<typename T>
T& MemoryPoolFast<T>::Create()
{
	int counter = counterRemove.IncInRangeRetPrev(GetCount());
	int extractedIndex = freeIndex[counter].GetIfNotEqualAndSet(free);
	T& t = data[extractedIndex].Get();
	::new(&t) T();
	return t;
}

template<typename T>
void MemoryPoolFast<T>::Destroy(T& t)
{
	t.~T();
	int insertedIndex = &t - &data.Begin()->Get();
	int counter = counterAdd.IncInRangeRetPrev(GetCount());
	freeIndex[counter].SetIfEqual(insertedIndex, free);
}

