#include "FastMemoryPoolTest.h"

struct MustAbsent : Exc
{
	MustAbsent(int v) : Exc(String() << "value " << v << " must be absent") {}
};

struct MustPresent : Exc
{
	MustPresent(int v) : Exc(String() << "value " << v << " must be present") {}
};

struct MapChecker
{
	void Add(void *p);
	void Remove(void *p);
	
private:
	void CheckAbsence(int v);
	void CheckPresence(int v);

	Index<int> data;
	Mutex mutex;
};

void MapChecker::Add(void *p)
{
	int v = (int) p;
	Mutex::Lock lock(mutex);
	CheckAbsence(v);
	data.Add(v);
}

void MapChecker::Remove(void *p)
{
	int v = (int) p;
	Mutex::Lock lock(mutex);
	CheckPresence(v);
	data.RemoveKey(v);
}

void MapChecker::CheckAbsence(int v)
{
	if (data.Find(v) >= 0)
		throw MustAbsent(v);
}

void MapChecker::CheckPresence(int v)
{
	if (data.Find(v) < 0)
		throw MustAbsent(v);
}

MapChecker checker;

AtomicValue stopper;
AtomicValue error;
AtomicValue totalIterations;

void Msg(const String& msg)
{
	INTERLOCKED
	{
		Cout() << msg << EOL;
	}
}

template<typename T_pool>
void Action1(int n, T_pool* pool)
{
	int i = 0;
	try
	{
		while (!stopper)
		{
			void *p = (void*) &pool->Create();
			checker.Add(p);
			checker.Remove(p);
			pool->Destroy(*(int*)p);
			++ i;
		}
	}
	catch (Exc& e)
	{
		stopper = 1;
		Msg(String() << "Error in thread " << n << ": " << e << ", iterations: " << i);
		error = 1;
		return;
	}
	totalIterations += i;
	Msg(String() << "Thread " << n << " finished, iterations: " << i);
}

template<typename T_pool>
bool Test1(int threads, int ms, T_pool& pool)
{
	stopper = 0;
	for (int i = 0; i < threads; ++ i)
		Thread::Start(callback2(Action1<T_pool>, i + 1, &pool));
	Thread::Sleep(ms);
	Msg(String() << "Completed");
	stopper = 1;
	Thread::ShutdownThreads();
	return error == 0;
}

template<typename T_pool>
void PoolTests(int n, T_pool& pool)
{
	totalIterations = 0;
	for (int i = 0; i < n; ++ i)
	{
		Msg(String() << "--- " << i);
		if (!Test1(10, 300, pool))
			break;
	}
}

void DoComplexTests()
{
	MemoryPool<int> pool(5);
	MemoryPoolFast<int> poolFast(5);

	Cout() << "### Perform pool test" << EOL;
	PoolTests(10, pool);
	Cout() << "### Pool test finished, total iterations: " << totalIterations << EOL;
	Cout() << "### Perform FAST pool test" << EOL;
	PoolTests(10, poolFast);
	Cout() << "### FAST pool test finished, total iterations: " << totalIterations << EOL;
}

