#include "FastMemoryPoolTest.h"

void testAtomic1()
{
	AtomicValue m = 3;
	m.IncInRange(5);
	Cout() << m << EOL;
}

void testAtomic2()
{
	AtomicValue m = 4;
	m.IncInRange(5);
	Cout() << m << EOL;
}

void testMemoryPool1()
{
	MemoryPool<int> pool(5);
	int& c = pool.Create();
	c = 3;
	Cout() << c << EOL;
	pool.Destroy(c);
}

void testMemoryPool2()
{
	MemoryPool<int> pool(2);
	int& a = pool.Create();
	int& b = pool.Create();
	Cout() << (void*)&a << EOL;
	Cout() << (void*)&b << EOL;
	pool.Destroy(b);
	int& c = pool.Create();
	Cout() << (void*)&c << EOL;
	//pool.Destroy(*(&c + 4));
}

struct Data1 : Moveable<Data1>
{
	Data1()		{ Cout() << __FUNCTION__ << EOL; }
	~Data1()	{ Cout() << __FUNCTION__ << EOL; }
	
	String s;
};

void testMemoryPool3()
{
	MemoryPool<Data1> p(3);
	Data1& d = p.Create();
	d.s = "hello";
	Cout() << d.s << EOL;
	p.Destroy(d);
}

void testMemoryPoolFast1()
{
	MemoryPoolFast<int> pool(2);
	int& a = pool.Create();
	int& b = pool.Create();
	Cout() << (void*)&a << EOL;
	Cout() << (void*)&b << EOL;
	pool.Destroy(b);
	int& c = pool.Create();
	Cout() << (void*)&c << EOL;
	a = 3;
	Cout() << a << EOL;
	pool.Destroy(a);
}

void testMemoryPoolFast2()
{
	MemoryPoolFast<Data1> p(3);
	Data1& d = p.Create();
	d.s = "hello";
	Cout() << d.s << EOL;
	p.Destroy(d);
}

void DoSimpleTests()
{
//	testAtomic1();
//	testAtomic2();
//	testMemoryPool1();
//	testMemoryPool2();
//	testMemoryPool3();
	testMemoryPoolFast1();
	testMemoryPoolFast2();
}

