struct AtomicValue : Moveable<AtomicValue>
{
	AtomicValue(long v = 0) : value(v)			{}
	
	bool TrySetIfEqual(long set, long check);
	void SetIfEqual(long set, long check);
	int GetIfNotEqualAndSet(long check);
	
	bool TryIncInRange(long max);
	void IncInRange(long max);
	long IncInRangeRetPrev(long max);
	
	bool TryMark();
	void Mark();
	bool TryUnmark();
	void Unmark();
	
	long operator~() const						{ return AtomicRead(value); }
	operator long() const						{ return AtomicRead(value); }
	void operator=(long v)						{ AtomicWrite(GetAtomic(), v); }
	void operator++()							{ AtomicInc(GetAtomic()); }
	void operator--()							{ AtomicDec(GetAtomic()); }
	void operator+=(long v)						{ AtomicXAdd(GetAtomic(), v); }

private:
	Atomic& GetAtomic()							{ return (Atomic&)value; }
	
	volatile long value;
};

inline String AsString(const AtomicValue& v)
{
	return AsString(~v);
}