#ifndef _CryptoPP_cryptopp_h_
#define _CryptoPP_cryptopp_h_

#include <CtrlLib/CtrlLib.h>

using namespace Upp;

#define _CRT_SECURE_NO_WARNINGS
#define _CRT_SECURE_NO_DEPRECATE
#define CRYPTOPP_DEFAULT_NO_DLL
#define CRYPTOPP_ENABLE_NAMESPACE_WEAK 1

//#include "./CryptoPP/dll.h"
#include "./CryptoPP/cryptlib.h"
#include "./CryptoPP/default.h"
#include "./CryptoPP/md5.h"
#include "./CryptoPP/sha.h"
#include "./CryptoPP/hex.h"
#include "./CryptoPP/rng.h"
#include "./CryptoPP/osrng.h"
#include "./CryptoPP/gzip.h"
#include "./CryptoPP/randpool.h"
#include "./CryptoPP/aes.h"
#include "./CryptoPP/ida.h"
#include "./CryptoPP/base64.h"
#include "./CryptoPP/files.h"
//#include "./CryptoPP/socketft.h"
#include "./CryptoPP/wait.h"
#include "./CryptoPP/factory.h"
#include "./CryptoPP/whrlpool.h"
#include "./CryptoPP/tiger.h"
#include "./CryptoPP/rsa.h"

#include <iostream>
#include <time.h>

class Crypto {	
public:
	Crypto();
	~Crypto();

public:
	void Test(const String &message);
	String HashMD5(const String &message);
	String HashSHA(const String &message);
	String EncryptString(const String &instr, const String &passPhrase);
	String DecryptString(const String &instr, const String &passPhrase);
	void GenerateRSAKey(const String &privFilename, const String &pubFilename, UINT keyLength = 2049);
	String RSAEncryptString(const String &pubFilename, const String &message);
	String RSADecryptString(const String &privFilename, const String &ciphertext);
};

#endif
