#ifndef _PlotCtrl_PlotCtrl_h
#define _PlotCtrl_PlotCtrl_h

#include <CtrlLib/CtrlLib.h>
#include <PlotLib/PlotLib.h>

using namespace Upp;

class PlotCtrl : public Ctrl, public Plot{
public:
	typedef PlotCtrl CLASSNAME;
	PlotCtrl();
	PlotCtrl& Zoom(double rx,double ry,Pointf C=Null);
	PlotCtrl& ZoomIn(double ratio=2,const Pointf& C=Null);
	PlotCtrl& ZoomOut(double ratio=2,const Pointf& C=Null);
	PlotCtrl& ZoomAll(bool visibleonly=false);
	virtual void Layout();
	virtual void Paint(Draw& w);
	virtual void LeftDown(Point pt,dword keyflags);
	virtual void RightDown(Point pt,dword keyflags);
	virtual void MouseMove(Point pt, dword keyflags);
	virtual void MiddleDown(Point pt,dword keyflags);
	virtual void MiddleUp(Point pt,dword keyflags);
	virtual void MouseLeave();
	virtual void MouseWheel(Point pt, int zdelta, dword keyflags);
	class PlotTracker : public RectTracker{
	public:
		virtual Image CursorImage(Point pt, dword keyflags);
		virtual void MouseMove(Point pt, dword keyflags);
		virtual void MiddleUp(Point pt, dword keflags);
		PlotTracker(PlotCtrl& master);
		PlotCtrl* p;
	};
protected:
	PlotTracker tr;
	Image img;
	Pointf mpos;
	Rectf lim;
};

class LegendCtrl : public Ctrl, public Legend{
public:
	typedef LegendCtrl CLASSNAME;
	LegendCtrl(Plot* p);
	virtual void Paint(Draw& w);
protected:
	unsigned hash;
	Image img;
};

#endif
