#ifndef _PlotLib_PlotSymbol_h_
#define _PlotLib_PlotSymbol_h_

#include <Painter/Painter.h>
using namespace Upp;

class PlotSymbol{
public:
	PlotSymbol();
	PlotSymbol(Sizef size,RGBA color,RGBA frame,double thickness);
	void Paint(Painter& sw,Pointf pos)const;
	unsigned GetHashValue()const;
	PlotSymbol& SetSize(Sizef size);
	PlotSymbol& SetSize(double cx,double cy);
	PlotSymbol& SetColor(RGBA color);
	PlotSymbol& SetFrameColor(RGBA color);
	PlotSymbol& SetThickness(double thickness);
	Sizef GetSize();
	RGBA GetColor();
	RGBA GetFrameColor();
	double GetThickness();
protected:
	Sizef s;
	RGBA c,f;
	double t;
	virtual void DoPaint(Painter& sw)const;
private:
	unsigned hash;
	Image img;
	void Refresh()const;
};

class Cross: public PlotSymbol{
public:
	Cross();
	Cross(Sizef size,RGBA color,RGBA frame,double thickness);
	virtual void DoPaint(Painter& sw)const;
};

class Xcross: public PlotSymbol{
public:
	Xcross();
	Xcross(Sizef size,RGBA color,RGBA frame,double thickness);
	virtual void DoPaint(Painter& sw)const;
};

class Circle: public PlotSymbol{
public:
	Circle();
	Circle(Sizef size,RGBA color,RGBA frame,double thickness);
	virtual void DoPaint(Painter& sw)const;
};

class Square: public PlotSymbol{
public:
	Square();
	Square(Sizef size,RGBA color,RGBA frame,double thickness);
	virtual void DoPaint(Painter& sw)const;
};

#endif
