topic "class PlotData : public Vector<Pointf>, private Moveable<PlotData>";
[2 $$0,0#00000000000000000000000000000000:Default]
[i448;a25;kKO9;2 $$1,0#37138531426314131252341829483380:class]
[l288;2 $$2,0#27521748481378242620020725143825:desc]
[0 $$3,0#96390100711032703541132217272105:end]
[H6;0 $$4,0#05600065144404261032431302351956:begin]
[i448;a25;kKO9;2 $$5,0#37138531426314131252341829483370:item]
[l288;a4;*@5;1 $$6,6#70004532496200323422659154056402:requirement]
[l288;i1121;b17;O9;~~~.1408;2 $$7,0#10431211400427159095818037425705:param]
[i448;b42;O9;2 $$8,8#61672508125594000341940100500538:tparam]
[b42;2 $$9,9#13035079074754324216151401829390:normal]
[{_} 
[s1;:PlotData`:`:class: [@(0.0.255)3 class][3 _][*3 PlotData][3 _:_][@(0.0.255)3 public][3 _][*@3;3 V
ector][3 <][_^Pointf^3 Pointf][3 >, ][@(0.0.255)3 private][3 _][*@3;3 Moveable][3 <][*3 PlotData][3 >
]&]
[s2;%% Class intended for storing information about functions/data 
to plot in [^topic`:`/`/PlotCtrl`/src`/PlotCtrl`$en`-us`#PlotCtrl`:`:class^ class 
PlotCtrl].&]
[s2;%% In addition to Vector, it introduces several attributes influencing 
the visual style of plot.&]
[s0; &]
[ {{10000F(128)G(128)@1 [s0;%% [* Visual attributes]]}}&]
[s0;^Color^ &]
[s5;:PlotData`:`:color: [_^Color^ Color]_[* color]&]
[s2;%% Color of the line. Defaults to [^topic`:`/`/Core`/src`/Color`$en`-us`#LtBlue`(`)^ L
tBlue()].&]
[s3; &]
[s4; &]
[s5;:PlotData`:`:thickness: [@(0.0.255) double]_[* thickness]&]
[s2;%% Width of line. Default value is 1.0&]
[s3; &]
[s4; &]
[s5;:PlotData`:`:dash: [_^String^ String]_[* dash]&]
[s2;%% Dashing pattern to use when rendering the line. Please not 
that the lengths of dashes are interpreted as double, so patterns 
like `"2.5 1.5e0`" are perfectly valid.&]
[s2;%% Examples:&]
[ {{1838:8162<288; [s0;%% `"`"]
:: [s0;%% Solid line ([/ default])]
:: [s0;%% `"1`"]
:: [s0;%% Dotted line (assuming thickness`=1)]
:: [s0;%% `"3`"]
:: [s0;%% Dashes 3px long with 3px spacing]
:: [s0;%% `"5 3`"]
:: [s0;%% Dashes 5px long with 3px spacing]
:: [s0;%% `"5 2 3 5`"]
:: [s0;%% Pattern 5px dash, 2px space, 3px dash, 5px space]}}&]
[s3; &]
[s4; &]
[s5;:PlotData`:`:title: [_^String^ String]_[* title]&]
[s2;%% Not fully implemented yet. In future this will be shown in 
legend. Defaults to empty string.&]
[s3; &]
[s4; &]
[s5;:PlotData`:`:visible: [@(0.0.255) bool]_[* visible]&]
[s2;%% If set to false, the dataset will not be drawn. To make the 
change visible after changing its value, you must call [^topic`:`/`/CtrlCore`/src`/Ctrl`$en`-us`#`:`:Ctrl`:`:SetModify`(`)^ S
etModify()] method of PlotCtrl drawing this dataset.&]
[s3; &]
[s0; &]
[ {{10000F(128)G(128)@1 [s0;%% [* Constructor Detail]]}}&]
[s0; &]
[s5;:PlotData`:`:PlotData`(`): [* PlotData]()&]
[s2;%% Default constructor, creates empty dataset.&]
[s3; &]
[s4; &]
[s5;:PlotData`:`:PlotData`(const Vector`<Pointf`>`&`): [* PlotData]([@(0.0.255) const]_[_^Vector^ V
ector]<[_^Pointf^ Pointf]>`&_[*@3 data])&]
[s2;%% Creates dataset from points in [%-*@3 data].&]
[s3;%% &]
[s4; &]
[s5;:PlotData`:`:PlotData`(const Array`<Pointf`>`&`): [* PlotData]([@(0.0.255) const]_[_^Array^ A
rray]<[_^Pointf^ Pointf]>`&_[*@3 data])&]
[s2;%% Creates dataset from points in [%-*@3 data].&]
[s3;%% &]
[s4; &]
[s5;:PlotData`:`:PlotData`(const Vector`<T`>`&`): [@(0.0.255) template]_<[@(0.0.255) clas
s]_[*@4 T]>_[* PlotData]([@(0.0.255) const]_[_^Vector^ Vector]<[*@4 T]>`&_[*@3 data])&]
[s2;%% Creates datset from [%-*@3 data], using its values as Y while 
X values are filled with indices.&]
[s3;%% &]
[s4; &]
[s5;:PlotData`:`:PlotData`(const Array`<T`>`&`): [@(0.0.255) template]_<[@(0.0.255) class
]_[*@4 T]>_[* PlotData]([@(0.0.255) const]_[_^Array^ Array]<[*@4 T]>`&_[*@3 data])&]
[s2;%% Creates datset from [%-*@3 data], using its values as Y while 
X values are filled with indices.&]
[s3;%% &]
[s4; &]
[s5;:PlotData`:`:PlotData`(const VectorMap`<K`,T`>`&`): [@(0.0.255) template]_<[@(0.0.255) c
lass]_[*@4 K], [@(0.0.255) class]_[*@4 T]>_[* PlotData]([@(0.0.255) const]_[_^VectorMap^ Vect
orMap]<[*@4 K],[*@4 T]>`&_[*@3 data])&]
[s2;%% Creates dataset from [%-*@3 data]. Keys are used as X, values 
as Y.&]
[s3;%% &]
[s4; &]
[s5;:PlotData`:`:PlotData`(const ArrayMap`<K`,T`>`&`): [@(0.0.255) template]_<[@(0.0.255) c
lass]_[*@4 K], [@(0.0.255) class]_[*@4 T]>_[* PlotData]([@(0.0.255) const]_[_^ArrayMap^ Array
Map]<[*@4 K],[*@4 T]>`&_[*@3 data])&]
[s2;%% Creates dataset from [%-*@3 data]. Keys are used as X, values 
as Y.&]
[s3; &]
[s0; &]
[ {{10000F(128)G(128)@1 [s0;%% [* Public Member List]]}}&]
[s0; &]
[s5;:PlotData`:`:SetDefaults`(`): [@(0.0.255) void]_[* SetDefaults]()&]
[s2;%% Restores all settings to default values (Visible solid blue 
line without title).&]
[s0; ]