#include <CtrlLib/CtrlLib.h>
#include <PlotCtrl/PlotCtrl.h>
using namespace Upp;

#define IMAGECLASS Symbol
#define IMAGEFILE <PlotCtrlExample/symbol.iml>
#include <Draw/iml.h>

// If you wish, you can define virtualy anyhing as symbol, just create a descendant 
// of class PlotSymbol and reimplement it's DoPaint method and constructor
class Bug: public PlotSymbol{
public:
	virtual void DoPaint(Painter& sw)const{
		sw.Rectangle(0,0,s.cx,s.cy).Fill(Symbol::bug(),0,0,s.cx,0);
	}
	Bug():PlotSymbol(Sizef(11,11),Color(),Color(),0){};
};

class PlotWindow : public TopWindow{
public:
	typedef PlotWindow CLASSNAME;
	PlotCtrl plot;
	LegendCtrl legend;
	PlotWindow():legend(&plot){
		Sizeable().Title("PlotCtrl Example").SetRect(200,200,640,480);
		plot.SetMode(PLOT_AA).SetLimits(-4,4,-4,4);
		Add(plot.HSizePos(0,0).VSizePos(0,0));
		legend.SetRect(60,10,1,1); //Size doesn't matter, it'll resize itself anyway
		legend.SetBackground(White());
		Add(legend);
//		plot.SetBackground(Color(0x444444,0)).SetFrameColor(Color(0x660000,0))
//		    .SetFontColor(White()).SetAxisColor(LtGreen());
//		legend.SetFrameColor(LtGreen()).SetBackground(Color(0x666666,0));
	}
	bool Key(dword keys, int count){
		if (keys==K_CTRL_A){
			plot.ZoomAll();
			return true;
		}
		if (keys==K_CTRL_L){
			if(legend.IsShown()){legend.Hide();}
			else{legend.Show();}
			return true;
		}
		return false;
	}
};

GUI_APP_MAIN{
	PlotWindow p;
	// You can create your data directly in plot ...
	p.plot.data.Add();
	p.plot.data[0].SetColor(LtRed()).SetTitle("Butterfly Curve");
	for(double t = -12*M_PI; t <= 12*M_PI; t+=0.02){
		double r=(exp(cos(t))-2*cos(4*t)+pow(sin(t/12),5));
		p.plot.data[0].Add(Pointf(r*sin(t),r*cos(t)));
	}
	
	// ... or take your data from elsewhere and copy them in plot. Supported types are
	//     Vector<Pointf>, VectorMap, and Vector of reasonable formats (i.e. convertable
	//     to double) + the same containers in Array flavor
	VectorMap<double,double> v;
	for(double x = -4; x <= 4; x+=0.05){
		v.Add(x,4*exp(-0.25*x*x)*sin(10*x));
	}
	p.plot.data.Add(v);
	p.plot.data[1].Dash("1.5").SetTitle("4*exp(-x^2/4)*sin(10*x)")
	              .SetThickness(1.5).SetSymbol(new Cross(Size(9,9),RGBAZero(),Blue(),1));
	
	// Now, just for fun: Let's clean last series and fill it with something random
	// to have something to show the Ladybugs on ;-)
	v.Clear();
	for(double x = -4; x <= 4; x+=0.5){
		v.Add(x,int(Random(7))-3);
	}
	p.plot.data.Add(v);
	p.plot.data[2].SetColor(Green()).SetTitle("Totally random")
	              .SetThickness(2).SetSymbol(new Bug);
	
	p.Run();
}
