#include "PlotLib.h"

Legend::Legend(Plot* plot):
	p(plot),fwidth(1),framecol(Black()),bgcol(RGBAZero()){}

Legend::Legend(Plot* plot,RGBA frame,RGBA background,double width):
	p(plot),fwidth(width),framecol(frame),bgcol(background){}

Size Legend::GetSize(){
	int maxlen=0;
	int vis=0;
	for(int i=0; i<p->data.GetCount(); i++){
		maxlen=max(maxlen,p->StrWidth(p->data[i].title));
		if(p->data[i].visible){vis++;}
	}
	return Size(maxlen+60,2*p->f.GetHeight()*vis);
}
Image Legend::GetLegend(){
	ImageBuffer ib(GetSize());
	BufferPainter bp(ib,p->mode);
	bp.Clear(bgcol);
	bp.Rectangle(fwidth*0.5,fwidth*0.5,ib.GetSize().cx-fwidth,ib.GetSize().cy-fwidth)
	  .Stroke(fwidth,framecol);
	int h=p->f.GetHeight();
	for(int i=0; i<p->data.GetCount(); i++){
		if(!p->data[i].visible){continue;}
		int y=2*h*i+3*h/2;
		bp.Dash(p->data[i].dash).DrawLine(10,y,40,y-h,p->data[i].t,p->data[i].color);
		bp.DrawText(50,y-h,p->data[i].title);
		if(p->data[i].symbol){
			p->data[i].symbol->Paint(bp,Pointf(25,y-h*0.5));
		}
	}
	return ib;
}

unsigned Legend::GetHashValue(){
	CombineHash hash;
	for(int i = 0; i < p->data.GetCount(); i++){
		hash<<p->data[i].visible;
		hash<<p->data[i].t;
		hash<<p->data[i].title;
		hash<<p->data[i].dash;
		hash<<Color(p->data[i].color);
		hash<<((p->data[i].symbol)?p->data[i].symbol->GetHashValue():(unsigned)0);
	}
	hash<<Color(bgcol);
	hash<<Color(framecol);
	return hash;
}

RGBA    Legend::GetFrameColor()               {return framecol;}
RGBA    Legend::GetBackground()               {return bgcol;   }
Plot*   Legend::GetPlot()                     {return p;       }
double  Legend::GetFrameWidth()               {return fwidth;  }
Legend& Legend::SetFrameColor(RGBA frame)     {framecol=frame;   return *this;}
Legend& Legend::SetBackground(RGBA background){bgcol=background; return *this;}
Legend& Legend::SetPlot(Plot* plot)           {p=plot;           return *this;}
Legend& Legend::SetFrameWidth(double width)   {fwidth=width;     return *this;}

