#include "PlotLib.h"

/* PlotData */

PlotData& PlotData::SetColor(RGBA col)            {color=col;     return *this;}
PlotData& PlotData::Visible(bool vis/* =true*/)   {visible=vis;   return *this;}
PlotData& PlotData::Invisible()                   {visible=false; return *this;}
PlotData& PlotData::Dash(String pattern/* =""*/)  {dash=pattern;  return *this;}
PlotData& PlotData::SetTitle(String str)          {title=str;     return *this;}
PlotData& PlotData::SetThickness(double thickness){t=thickness;   return *this;}
PlotData& PlotData::SetSymbol(PlotSymbol* Symbol) {symbol=Symbol; return *this;}
RGBA PlotData::GetColor()                         {return color;   }
bool PlotData::IsVisible()                        {return visible; }
String PlotData::GetDash()                        {return dash;    }
String PlotData::GetTitle()                       {return title;   }
double PlotData::GetThickness()                   {return t;       }
PlotSymbol& PlotData::GetSymbol()                 {return *symbol; }

PlotData::PlotData(){
	SetDefaults();
}
PlotData::PlotData(const Vector<Pointf>& data){
	SetCount(data.GetCount());
	for(int i=0;i<data.GetCount();i++){
		(*this)[i]=data[i];
		BB.Union(data[i]);
	}
	SetDefaults();
}
PlotData::PlotData(const Array<Pointf>& data){
	SetCount(data.GetCount());
	for(int i=0;i<data.GetCount();i++){
		(*this)[i]=data[i];
		BB.Union(data[i]);
	}
	SetDefaults();
}
PlotData& PlotData::SetDefaults(){
	color=LtBlue();
	dash="";
	title="";
	visible=true;
	t=1;
}
void PlotData::RefreshBB(){
	BB.Clear();
	for(int i = 0; i < GetCount(); i++){
		BB.Union((*this)[i]);
	}
}
