#ifndef _PlotLib_PlotLib_h
#define _PlotLib_PlotLib_h

#include <Painter/Painter.h>
using namespace Upp;

#include "PlotSymbol.h"

enum{
	PLOT_AA          = MODE_ANTIALIASED,
	PLOT_NOAA        = MODE_NOAA,
	PLOT_SUBPIXEL    = MODE_SUBPIXEL
};
class Plot;

class PlotData:public Vector<Pointf>, Moveable<PlotData>{
protected:
	RGBA color;
	double t;
	String dash,title;
	bool visible;
	Rectf BB;
	void RefreshBB();
	One<PlotSymbol> symbol;
public:
	PlotData&   SetColor(RGBA col);
	PlotData&   Visible(bool vis=true);
	PlotData&   Invisible();
	PlotData&   Dash(String pattern="");
	PlotData&   SetTitle(String str);
	PlotData&   SetThickness(double thickness);
	PlotData&   SetDefaults();
	PlotData&   SetSymbol(PlotSymbol* Symbol);
	RGBA        GetColor();
	bool        IsVisible();
	String      GetDash();
	String      GetTitle();
	double      GetThickness();
	PlotSymbol& GetSymbol();
	friend class Legend;
	friend class Plot;
	PlotData();
	PlotData(const Vector<Pointf>& data);
	PlotData(const Array<Pointf>& data);
	template <class T>
	PlotData(const Vector<T>& data){
		SetCount(data.GetCount());
		for(int i=0;i<data.GetCount();i++){
			(*this)[i]=Pointf(i,data[i]);
			BB.Union((*this)[i]);
		}
		SetDefaults();
	}
	template <class T>
	PlotData(const Array<T>& data){
		SetCount(data.GetCount());
		for(int i=0;i<data.GetCount();i++){
			(*this)[i]=Pointf(i,data[i]);
			BB.Union((*this)[i]);
		}
		SetDefaults();
	}
	template <class K, class T>
	PlotData(const VectorMap<K,T>& data){
		SetCount(data.GetCount());
		for(int i=0;i<data.GetCount();i++){
			(*this)[i]=Pointf(data.GetKey(i),data[i]);
			BB.Union((*this)[i]);
		}
		SetDefaults();
	}
	template <class K, class T>
	PlotData(const ArrayMap<K,T>& data){
		SetCount(data.GetCount());
		for(int i=0;i<data.GetCount();i++){
			(*this)[i]=Pointf(data.GetKey(i),data[i]);
			BB.Union((*this)[i]);
		}
		SetDefaults();
	}
};
class Legend{
public:
	Legend(Plot* plot);
	Legend(Plot* plot,RGBA frame,RGBA background,double width=1);
	Image    GetLegend();
	Size     GetSize();
	unsigned GetHashValue();
	Plot*    GetPlot();
	RGBA     GetFrameColor();
	RGBA     GetBackground();
	double   GetFrameWidth();
	Legend&  SetPlot(Plot* plot);
	Legend&  SetFrameColor(RGBA frame);
	Legend&  SetBackground(RGBA background);
	Legend&  SetFrameWidth(double width);
	friend class Plot;
private:
	Plot* p;
	double fwidth;
	RGBA bgcol,framecol;
};
class Plot{
public:
	Plot();
	Vector<PlotData> data;
	Plot& SetLimits(double x_min,double x_max,double y_min,double y_max);
	Plot& SetLimits(const Rectf& rect);
	Rectf GetLimits()const;
	Rectf BoundingBox(bool visibleonly=false);
	Plot& SetFont(const Font& font);
	Font GetFont()const;
	Plot& SetBackground(const Color& c);
	Color GetBackground()const;
	Plot& SetFrameColor(const Color& c);
	Color GetFrameColor()const;
	Plot& SetFontColor(const Color& c);
	Color GetFontColor()const;
	Plot& SetAxisColor(const Color& c);
	Color GetAxisColor()const;
	Plot& SetMode(int mode);
	Plot& SetPlotSize(const Size& sz);
	Plot& SetPlotSize(double cx,double cy);
	Size GetPlotSize()const;
	Image GetImage();
	bool CheckRange()const;
	String ImgToPlotFormatted(const Point& X)const;
	String ImgToPlotFormatted(const Rect& X)const;
	int StrWidth(const char *str)const;
	Pointf ImgToPlot(const Pointf& X)const;
	Rectf ImgToPlot(const Rectf& X)const;
	Pointf PlotToImg(const Pointf& X)const;
	Rectf PlotToImg(const Rectf& X)const;
	friend class Legend;
private:
	int mode;
	double sx,sy;
	Rectf g;
	Rect p;
	Font f;
	FontInfo fi;
	Size size;
	Color bgcol,framecol,fontcol,axiscol;
	int marginB,marginL,marginR,marginT,margin,spaceH;
	double Gx(double x)const;
	double Gy(double y)const;
	Pointf G(Pointf X)const;
	Rectf G(Rectf X)const;
	double Sx(double x)const;
	double Sy(double y)const;
	Pointf S(Pointf X)const;
	Rectf S(Rectf X)const;
	void TickH(double x,int e,Painter& sw);
	void TickV(double y,int e,Painter& sw);
	void NormalizeStep(double& s,int& e)const;
	bool Axes(Painter& sw);
	void PaintData(const PlotData& data,Painter& sw);
	int LineClip(double& x1, double& y1, double& x2, double& y2)const;
};

#endif

