#include "PlotCtrl.h"

#define IMAGECLASS PlotCursors
#define IMAGEFILE <PlotCtrl/cursors.iml>
#include <Draw/iml.h>

PlotCtrl::PlotCtrl():tr(*this),mpos(Null){
	BackPaint();
}
PlotCtrl& PlotCtrl::Zoom(double rx,double ry,Pointf C){
	OverrideCursor(Image::Wait());
	Rectf g=GetLimits();
	if(C.IsNullInstance()){C=g.CenterPoint();}
	SetLimits(RectfC(C.x-rx*(C.x-g.left),C.y-ry*(C.y-g.top),rx*g.Width(),ry*g.Height()));
	SetModify();
	Refresh();
	Sync();
	MouseMove(GetMousePos(),0);
	return *this;
}
PlotCtrl& PlotCtrl::ZoomIn(double ratio,const Pointf& C){
	return Zoom(1/ratio,1/ratio,C);
}
PlotCtrl& PlotCtrl::ZoomOut(double ratio,const Pointf& C){
	return Zoom(ratio,ratio,C);
}
PlotCtrl& PlotCtrl::ZoomAll(bool visibleonly){
	OverrideCursor(Image::Wait());
	SetLimits(BoundingBox(visibleonly));
	SetModify();
	Refresh();
	Sync();
	MouseMove(GetMousePos(),0);
	return *this;
}
void PlotCtrl::Layout(){
	SetPlotSize(GetSize());
	//tr=PlotTracker(*this);
	SetModify();
}
void PlotCtrl::Paint(Draw& w){
	if(IsModified()){
		img=GetImage();
		if(img.IsEmpty()){
			ZoomAll();
			PromptOK("You've reached precision limits.&Zoom setting was changed.");
			Refresh();
			Sync();
			return;
		}else{
			ClearModify();
		}
	}
	w.DrawImage(0,0,img);
}
void PlotCtrl::LeftDown(Point pt,dword keyflags){
	if(keyflags&K_CTRL){
		ZoomAll();
	}else{
		if(tr.InLoop()){tr.Close();return;} //sometimes RectTracker "forgets" to leave the loop...
		Rectf r=tr.Track(RectfC(pt.x,pt.y,0,0),ALIGN_NULL,ALIGN_NULL);
		if((r.Width()!=0)&&(r.Height()!=0)){
			SetLimits(ImgToPlot(r));
		}else{
			ZoomIn(2,ImgToPlot(pt));
		}
		OverrideCursor(PlotCursors::cross);
		if(CheckRange()){
			SetModify();
			Refresh();
			Sync();
		}
	}
}
void PlotCtrl::MouseMove(Point pt, dword keyflags){
	if(!mpos.IsNullInstance()){
		SetLimits(lim); //this is to make ImgToPlot conversion work correctly
		SetLimits(lim.Offseted(mpos-ImgToPlot(pt)));
		SetModify();
		OverrideCursor(PlotCursors::pan);
		Refresh();Sync();
		return;
	}
	String pos=ImgToPlotFormatted(pt);
	ImageDraw w(15+StrWidth(pos),15+GetFont().GetHeight());
	w.DrawRect(0,0,15+StrWidth(pos),15+GetFont().GetHeight(),Black());
	w.Alpha().DrawRect(0,0,15+StrWidth(pos),15+GetFont().GetHeight(),GrayColor(0));
	w.Alpha().DrawImage(0,0,PlotCursors::cross,GrayColor(255));
	w.Alpha().DrawText(11,11,pos,GetFont(),GrayColor(255));
	ImageBuffer b(w);
	b.SetHotSpot(Point(8,8));
	OverrideCursor(b);
}
void PlotCtrl::RightDown(Point pt,dword keyflags){
	Pointf pf(1.0*pt.x,1.0*pt.y);
	ZoomOut(2,ImgToPlot(pt));
	if(!CheckRange()){
		SetModify();
		PromptOK("Oups, you'have reached double precision limits...&Plot changed its zoom settings to avoid freezing application.");
	}
}
void PlotCtrl::MouseWheel(Point pt, int zdelta, dword keyflags){
	if(IsModified()) return; // only accept event if ready
	zdelta/=60.0;
	if(zdelta<0){ZoomOut(-zdelta,ImgToPlot(pt));}
	else{ZoomIn(zdelta,ImgToPlot(pt));}
}
void PlotCtrl::MiddleDown(Point pt,dword keyflags){
	mpos=ImgToPlot(pt);
	lim=GetLimits();
	OverrideCursor(PlotCursors::pan);
}
void PlotCtrl::MiddleUp(Point pt,dword keyflags){
	mpos=Null;
	MouseMove(pt,keyflags);
}
void PlotCtrl::MouseLeave(){
	mpos=Null;
}

/* PlotCtrl::PlotTracker */
PlotCtrl::PlotTracker::PlotTracker(PlotCtrl& master):RectTracker(master){p=&master;}

void PlotCtrl::PlotTracker::MouseMove(Point pt, dword keyflags){
	OverrideCursor(CursorImage(pt,keyflags)); // this is generally bad idea, 
	RectTracker::MouseMove(pt,keyflags);      // but it reduces flickering a bit
}
Image PlotCtrl::PlotTracker::CursorImage(Point pt, dword keyflags){
	String pos=(*p).ImgToPlotFormatted(rect);
	Rect t(0,0,15+(*p).StrWidth(pos),15+2*(*p).GetFont().GetHeight());
	ImageDraw w(t.Width(),t.Height());
	w.DrawRect(t,Black());
	w.Alpha().DrawRect(t,GrayColor(0));
	w.Alpha().DrawImage(0,0,PlotCursors::cross,GrayColor(255));
	w.Alpha().DrawText(11,11,pos,(*p).GetFont(),GrayColor(255));
	ImageBuffer b(w);
	b.SetHotSpot(Point(8,8));
	return b;
}
void PlotCtrl::PlotTracker::MiddleUp(Point pt, dword keflags){
	EndLoop();
}
