#include "PlotSymbol.h"

PlotSymbol::PlotSymbol():s(0,0),c(RGBAZero()),f(RGBAZero()),t(0){};
PlotSymbol::PlotSymbol(Sizef size,RGBA color,RGBA frame,double thickness):
	s(size),c(color),f(frame),t(thickness){};
void PlotSymbol::Paint(Painter& sw,Pointf pos)const{
	if(hash!=GetHashValue()){Refresh();}
	sw.Offset(pos.x-s.cx*0.5,pos.y-s.cy*0.5);
	 sw.Rectangle(0,0,s.cx,s.cy).Fill(img,0,0,s.cx,0);
	sw.End();
}
unsigned PlotSymbol::GetHashValue()const{
	return CombineHash(Color(c),Color(f),s,t);
}
void PlotSymbol::DoPaint(Painter& sw)const{}
void PlotSymbol::Refresh()const{
	ImageBuffer ib(s);
	BufferPainter bp(ib);
	bp.Clear(RGBAZero());
	DoPaint(bp);
	*(const_cast<Image*>(&img))=ib;
	*(const_cast<unsigned*>(&hash))=GetHashValue();
}

PlotSymbol& PlotSymbol::SetSize(Sizef size)           {s=size;         return *this;}
PlotSymbol& PlotSymbol::SetSize(double cx,double cy)  {s=Sizef(cx,cy); return *this;}
PlotSymbol& PlotSymbol::SetColor(RGBA color)          {c=color;        return *this;}
PlotSymbol& PlotSymbol::SetFrameColor(RGBA color)     {f=color;        return *this;}
PlotSymbol& PlotSymbol::SetThickness(double thickness){t=thickness;    return *this;}
Sizef PlotSymbol::GetSize()                           {return s;}
RGBA PlotSymbol::GetColor()                           {return c;}
RGBA PlotSymbol::GetFrameColor()                      {return f;}
double PlotSymbol::GetThickness()                     {return t;}

Cross::Cross(){};
Cross::Cross(Sizef size,RGBA color,RGBA frame,double thickness):
	PlotSymbol(size,color,frame,thickness){};
void Cross::DoPaint(Painter& sw)const{
	sw.Move(0,0.5*s.cy).Line(s.cx,0,true).Stroke(t,f);
	sw.Move(0.5*s.cx,0).Line(0,s.cy,true).Stroke(t,f);
}


Xcross::Xcross(){};
Xcross::Xcross(Sizef size,RGBA color,RGBA frame,double thickness):
	PlotSymbol(size,color,frame,thickness){};
void Xcross::DoPaint(Painter& sw)const{
	sw.Move(0,   0).Line(s.cx, s.cy,true).Stroke(t,f);
	sw.Move(0,s.cy).Line(s.cx,-s.cy,true).Stroke(t,f);
}


Circle::Circle(){};
Circle::Circle(Sizef size,RGBA color,RGBA frame,double thickness):
	PlotSymbol(size,color,frame,thickness){};
void Circle::DoPaint(Painter& sw)const{
	sw.Ellipse(0.5*s.cx,0.5*s.cy,0.5*(s.cx-t),0.5*(s.cy-t));
	sw.Fill(c).Stroke(t,f);
}


Square::Square(){};
Square::Square(Sizef size,RGBA color,RGBA frame,double thickness):
	PlotSymbol(size,color,frame,thickness){};
void Square::DoPaint(Painter& sw)const{
	sw.Rectangle(t*0.5,t*0.5,s.cx-t,s.cy-t);
	sw.Fill(c).Stroke(t,f);
}


