#include "CtrlLib/CtrlLib.h"

using namespace Upp;

//moving controls from one tree to another is somehow dieeferent then making a copy
//it means removing their items in source, not making a copy,
//but for us here it means saving the ctrl reference, if any
int Move(TreeCtrl& dst, int did, int i, TreeCtrl& src, int id)
{
	TreeCtrl::Node x = src.GetNode(id);

	//x.ctrl = NULL; //want to keep it
	//so we remove it first
	if(x.ctrl) x.ctrl->Remove();

	did = dst.Insert(did, i, x);
	x.ctrl = NULL; //prevent rmoving
	src.SetNode(id, x); //and set the empty node //FIXME, check if is right

	dst.Open(did, src.IsOpen(id));
	for(int i = 0; i < src.GetChildCount(id); i++)
		Move(dst, did, i, src, src.GetChild(id, i));
	return did;
}

//checks whether in src TreeCtrl, parent element is a parent or grandparent of id element 
bool IsGrandParent(const TreeCtrl & src, int parent, int id)
{
	if(parent == id) return false; //we are same, parent cant be parent of id
	int parent_ = src.GetParent(id);
	if(parent_<0)
		return false; //not found or not direct parent
	//encountered a real parent, check if parent is maybe its parent
	if(parent_ == parent) return true; //yes, parent is a parent/grandparent of id
	else return IsGrandParent(src, parent, parent_); //no, might be grand parent
}

void InsertDrop(TreeCtrl & dest, int parent, int ii, TreeCtrl& src, PasteClip& d)
{
	TreeCtrl copy;
	Vector<int> sel = src.GetSel(); //besorg die selected items
	
	//check if a selection element is our parent's direct ancestor
	for(int i = 0; i < sel.GetCount(); i++)
		if((sel[i] == parent) || IsGrandParent(src, sel[i], parent)) //we cant rely on IsGrandParent in this special case
			return;
	
	for(int i = 0; i < sel.GetCount(); i++) //schieb erst mal alles was selected war, irgendwie flat zusammen
		Move(copy, 0, i, src, sel[i]);

	Vector<int> did; //schieb den flachen raum der selection wieder hierher
	for(int i = 0; i < copy.GetChildCount(0); i++) {
		did.Add(Move(dest, parent, ii + i, copy, copy.GetChild(0, i)));
		dest.SetCursor(did.Top());
	}
	if(&src == &dest && d.GetAction() == DND_MOVE) { //wenn wir auf uns selbst verschoben haben, im uebergeorndeten code nicht RemoveSelection erlauben
		src.Remove(sel); //NOT HERE, but in Move
		d.SetAction(DND_COPY);
	}
	for(int i = 0; i < did.GetCount(); i++) //markiert die eingefuegten, die schon an ihrem platz sind
		dest.SelectOne(did[i], true);
}

struct App : TopWindow {
	TreeCtrl   tree;
	Array<EditString> edit;

	typedef App CLASSNAME;

	void DropInsert(int parent, int ii, PasteClip& d)
	{
		tree.AdjustAction(parent, d);
		if(AcceptInternal<TreeCtrl>(d, "mytreedrag")) {
			//tree.InsertDrop(parent, ii, d);
			InsertDrop(tree, parent, ii, tree, d);
			tree.SetFocus();
			return;
		}
		if(AcceptText(d)) {
			tree.SetCursor(tree.Insert(parent, ii, Image(), GetString(d)));
			tree.SetFocus();
			return;
		}
	}

	void Drag()
	{
		if(tree.DoDragAndDrop(InternalClip(tree, "mytreedrag"),
		                       tree.GetDragSample()) == DND_MOVE)
			tree.RemoveSelection();
	}

	App() {
		Add(tree.SizePos());
		Vector<int> parent, parent2;
		parent.Add(0);
		tree.SetRoot(CtrlImg::menu_window(), "Groups");
		for(int i = 1; i < 10/*000*/; i++) {
			EditString & es = edit.Add();
			es.SetText(FormatIntRoman(i, true));
			parent.Add(tree.Add(parent[rand() % parent.GetCount()], CtrlImg::open(),
			            es));
			if((rand() & 3) == 0)
				tree.Open(parent.Top());
		}
		tree.Open(0);
		tree.WhenDropInsert = THISBACK(DropInsert);
		tree.WhenDrag = THISBACK(Drag);
		tree.MultiSelect();
		Sizeable();
	}
};

GUI_APP_MAIN
{
	App().Run();
}
