#include "EyeCare.h"

#define IMAGECLASS EyeCareImg
#define  IMAGEFILE <EyeCareAris/EyeCare.iml>
#include <Draw/iml.h>

#ifdef _DEBUG
#define MINUTE_M 1000 // to reduce waiting when debugging....
#else
#define MINUTE_M 60 * 1000
#endif

void EyeCareWindow::About()
{
	start.Kill();
	ignore++;
	WithAboutDialogLayout<TopWindow> dlg;
	CtrlLayoutOK(dlg, "About EyeCare");
	dlg.CenterScreen();
	dlg.Run();
	ignore--;
}

void EyeCareWindow::Restart()
{
	relax.KillSet(-(int)~config.relax * MINUTE_M, THISBACK(Relax));
	wash.KillSet(-(int)~config.wash * MINUTE_M, THISBACK(Wash));
}

void EyeCareWindow::Sync()
{
#ifdef PLATFORM_WIN32
	ExStyle(config.topmost ? GetExStyle() | WS_EX_TOPMOST
	                       : GetExStyle() & ~WS_EX_TOPMOST);
#endif
}

void EyeCareWindow::Perform(const char *txt1, const char *txt2)
{
	start.Kill();
	text1 = txt1;
	text2 = txt2;
	if(!IsOpen())
		OpenMain();
	Show();
	SetForeground();
}

void EyeCareWindow::Launch()
{
	Perform(t_("Welcome to Eye Care!"),
	        t_("This program will remind you at regular intervals \n"
	           "to take care of your eyes and relax/wash them."));
}

void EyeCareWindow::EndStart()
{
	Hide();
}

void EyeCareWindow::StartLaunch()
{
	Launch();
	start.Set(15000, THISBACK(EndStart));
}

void EyeCareWindow::Relax()
{
	if(ignore) return;
	BeepInformation();
	Perform(t_("Eye relaxing time..."),
	        t_("Now move your eyes away, from the monitor\n"
	           "and view some distant object for 15 seconds."));
}

void EyeCareWindow::Wash()
{
	if(ignore) return;
	BeepInformation();
	Perform(t_("Eye washing time..."),
	        t_("Now move to the wash room, and gently wash \n"
	           "your eyes with water to prevent dryness."));
}

void EyeCareWindow::Configure()
{
	start.Kill();
	relax.Kill();
	wash.Kill();
	config.Execute();
	WhenConfig();
	Restart();
	Sync();
}

void EyeCareWindow::MainMenu(Bar& bar)
{
	bar.Add(t_("Settings"), THISBACK(SettingsBar) );
	bar.Add(t_("Help"), THISBACK(HelpBar) );
}

void EyeCareWindow::SettingsBar(Bar& bar)
{
	bar.Add(t_("Configuration"), THISBACK(Configure))
	   .Help(t_("Change settings"));
	bar.Add(t_("Exit"), WhenExit)
	   .Help(t_("Exit the application"));
}

void EyeCareWindow::HelpBar(Bar& bar)
{
	bar.Add(t_("About"), THISBACK(About))
	   .Help(t_("About EyeCare"));
}

void EyeCareWindow::Serialize(Stream& s)
{
	int version = 1;
	s / version;
	s % config.relax % config.wash % config.hideicon % config.topmost;
	s % ignore;
	SerializePlacement(s);
}

EyeCareWindow::EyeCareWindow()
{
	CtrlLayoutOKCancel(config, t_("Configuration"));
	CtrlLayout(*this, t_("EyeCare"));
	menu.Set(THISBACK(MainMenu));
	image.SetImage(EyeCareImg::eye());
	CenterScreen();
	hide <<= THISBACK(Hide);
	config.relax <<= 5;
	config.wash <<= 55;
	Icon(EyeCareImg::icon());
}

void EyeCare::Exit()
{
	eyecare.Break();
	Break();
}

void EyeCare::Menu(Bar& bar)
{
	bar.Add(t_("Show EyeCare"), callback(&eyecare, &EyeCareWindow::Launch));
	bar.Add(t_("Ignore eyes"), THISBACK(Ignore))
	   .Check(ignore);
	bar.Add(t_("About.."), callback(&eyecare, &EyeCareWindow::About));
	bar.Add(t_("Exit"), THISBACK(Exit));
}

EyeCare::EyeCare()
{
	WhenBar = THISBACK(Menu);
	WhenLeftDouble = callback(&eyecare, &EyeCareWindow::Launch);
	eyecare.WhenExit = THISBACK(Exit);
	eyecare.WhenConfig = THISBACK(Sync);
	Tip(t_("EyeCare"));
	ignore = false;
}

void EyeCare::Serialize(Stream& s)
{
	int version = 1;
	s / version;
	s % eyecare % ignore;
}

void EyeCare::Sync()
{
	Icon(ignore ? EyeCareImg::off() : EyeCareImg::on());
	if(eyecare.HideIcon())
		ignore = false;
	Show(!eyecare.HideIcon());
	eyecare.Sync();
	eyecare.SetIgnore(ignore);
	eyecare.Restart();
}

void EyeCare::Ignore()
{
	ignore = !ignore;
	Sync();
}

void EyeCare::Start()
{
	eyecare.StartLaunch();
}

GUI_APP_MAIN
{
#ifdef PLATFORM_WIN32
	static const char unique_name[] = "EyeCare___U++";
	if(::FindWindow(NULL, unique_name)) {
		Exclamation(t_("EyeCare is already running."));
		return;
	}
	TopWindow singlechk;
	singlechk.SetRect(-1, -1, 1, 1);
	singlechk.Title(unique_name);
	singlechk.Open();
#endif

	EyeCare app;
	LoadFromFile(app);
	app.Sync();
	app.Start();
	app.Run();
	StoreToFile(app);
}
