#ifndef _EyeCareAris_EyeCare_h_
#define _EyeCareAris_EyeCare_h_

#include <CtrlLib/CtrlLib.h>

#define LAYOUTFILE <EyeCareAris/EyeCare.lay>
#include <CtrlCore/lay.h>

class EyeCareWindow : public WithEyeCareLayout<TopWindow> {
	WithConfigurationLayout<TopWindow> config;
	TimeCallback relax, wash, start;
	int ignore;

	void Perform(const char *txt1, const char *txt2);
	void Relax();
	void Wash();
	void Configure();
	void EndStart();

	void MainMenu(Bar& menu);
	void SettingsBar(Bar& bar);
	void HelpBar(Bar& bar);

public:
	Callback WhenExit;
	Callback WhenConfig;

	void SetIgnore(bool _ignore)           { ignore = _ignore; }
	void Launch();
	void Restart();
	void Sync();
	bool HideIcon()                        { return config.hideicon; }
	void About();
	void StartLaunch();

	void Serialize(Stream& s);

	typedef EyeCareWindow CLASSNAME;

	EyeCareWindow();
};

class EyeCare : public TrayIcon {
	EyeCareWindow eyecare;
	bool ignore;
	TimeCallback start;

	void Menu(Bar& bar);
	void Exit();
	void Ignore();

public:
	void Sync();
	void Start();
	void Serialize(Stream& s);

	typedef EyeCare CLASSNAME;

	EyeCare();
};

#endif
