#ifndef _Reports3_RepGen_h_
#define _Reports3_RepGen_h_

#include <Report/Report.h>
#include <Core/Core.h>

using namespace Upp;

//Module maximized window


class RepGen  {
public:
	typedef Vector<int> DepthContextType;

private:
	String tpl,tplb,tplbr;
	String result,resultb;
	bool ENDCALCULATE;
	
	void PCRE_Replace(String& where, String s_from,String s_to);
	

	class ContextManager
	{
		private:
			DepthContextType ctxt;
			int nextContextVal;

		public:
			ContextManager(): nextContextVal(0)
			{
				//ctxt << 0; // default context
			}
			
			inline void incDepth()
			{
				ctxt << nextContextVal;
				nextContextVal = 0;
			}
			
			inline void decDepth()
			{
				nextContextVal = ctxt[ctxt.GetCount()-1] + 1;
				ctxt.Remove(ctxt.GetCount()-1);
			}
			
			void logContext(String txt = "");
	
			inline const DepthContextType& getCtxt() { return ctxt; }
	};

	ContextManager ctxtMngr;
	
public:
	typedef RepGen CLASSNAME;
	RepGen() {};
	void Perform();
	
	Callback RepGenReportStart;
	Callback RepGenReportVar;
	Callback RepGenReportFinish;
	Callback1<const DepthContextType&> RepGenCalculateStart;
	Callback1<const DepthContextType&> RepGenCalculateBody;
	Callback1<const DepthContextType&> RepGenCalculateFinish;

	void SubstVar(String s_from,String s_to) { PCRE_Replace(tpl, s_from, s_to); };
	void SubstVarInLoopBody(String s_from,String s_to) { PCRE_Replace(tplbr , s_from, s_to); };
	void SetTemplate(String tpl0) { tpl=Join(Split(tpl0,'\n'),""); };
	void LoopDone(bool indicator=true) { ENDCALCULATE = indicator; };
	void PlaceImage(String s_from, Image im_to, Size rep_place = Size(0,0));
	void PlaceImageInLoopBody(String s_from, Image im_to, Size rep_place = Size(0,0));
	
	inline void logContext(String txt = "") { ctxtMngr.logContext(txt); }
};

#endif
