#ifndef _MyPtrTest_MyPtrTest_h
#define _MyPtrTest_MyPtrTest_h

#include <Core/Core.h>

using namespace Upp;


class Person: public Pte<Person>
{
	public:
		Person()
		{
		}
		
		virtual ~Person()
		{
		}
		
		virtual String toString()
		{ 
			return "";
		}
};

class NPerson;

class JPerson: public Person
{
	public:
		JPerson( const String &pname = "" )
		{
			name = pname;
		}
		
		JPerson( const JPerson &p )
		{
			name = p.name;
			chairman = p.chairman;
		}
		
		~JPerson()
		{
			delete( chairman );
		}
		
		virtual String toString()
		{
			String info = name;
			if(chairman)
			{
				info += Format(" has chairman : %s \t ", ( (Person *) chairman)->toString() );
				//info += chairman.ToString();
			}
			
			return info;
		}

		bool setChairman( NPerson * p)
		{
			if(p)
			{
				chairman = ( Person *) p;
				RLOG( "JPerson " << chairman.ToString());
				return true;
			}
			return false;
		}
		
	private:
		String name;
		Ptr<Person> chairman;
};


class NPerson: public Person
{
	public:
		NPerson( const String &pname = "" )
		{
			name = pname;
		}
		NPerson( const NPerson &p)
		{
			name = p.name;
			membership = p.membership;
		}
		
		~NPerson()
		{
			delete( membership );
		}
		
		virtual String toString()
		{
			String info = name;
			if(membership)
			{
				info += Format(" is member of : %s \t ", ( (Person *) membership)->toString() );
				//info += membership.ToString();
			}
			return info;
		}

		bool setMembership( JPerson * p)
		{
			if(p)
			{
				membership = ( Person *) p;
				RLOG( "NPerson " << membership.ToString());
				return true;
			}
			return false;
		}
		
	private:
		String name;
		Ptr<Person> membership;
};


#endif
