#include <CtrlLib/CtrlLib.h>
#include "ConnSock.h"
#include <Web/Web.h>

using namespace Upp;

#define LAYOUTFILE <Neilson1/dlg.lay>
#include <CtrlCore/lay.h>

struct MyApp : public WithDlgLayout<TopWindow> {
	typedef MyApp CLASSNAME; 	// This makes the THISBACK macro work
	MenuBar menu;			// This is your menu bar
	
	MyApp() {
		CtrlLayout(*this, "Neilson1");
		AddFrame(menu); 		// To make a menu bar you must add the frame before setting the callback
		menu.Set(THISBACK(MainMenu));   // Set the menu callback
	}
	
	// Main menu bar
	void MainMenu(Bar& bar) {
		bar.Add("File", THISBACK(FileMenu));
		bar.Add("Settings", THISBACK(SettingsMenu));
		bar.Add("Points", THISBACK(PointsMenu));
		bar.Add("Calculate", THISBACK(CalculateMenu));
	}
	
	// File sub-menu
	void FileMenu(Bar& bar) {
		bar.Add("Open File", THISBACK(Exit));
		bar.Add("Clear File", THISBACK(Exit));
		bar.Add("Exit", THISBACK(Exit));
	}
	
	// Settings sub-menu
	void SettingsMenu(Bar& bar) {
		bar.Add("meters", THISBACK(GetP1));
		bar.Add("km", THISBACK(GetP2));
		bar.Add("feet", THISBACK(GoToP1));
		bar.Add("miles", THISBACK(GoToP2));
		bar.Add("naut mi", THISBACK(GoToP2));

		bar.Add("degrees", THISBACK(GetP1));
		bar.Add("deg min", THISBACK(GetP2));
		bar.Add("deg min sec", THISBACK(GoToP1));
		
		bar.Add("8dist", THISBACK(GetP1));
		bar.Add("6dist", THISBACK(GetP2));
		bar.Add("5dist", THISBACK(GoToP1));
		bar.Add("4dist", THISBACK(GoToP2));
		
		bar.Add("Direct", THISBACK(GetP1));
		bar.Add("Fly To", THISBACK(GetP2));
		
		bar.Add("Draw", THISBACK(GetP1));
		bar.Add("No Draw", THISBACK(GetP2));
		
		bar.Add("Clear", THISBACK(GetP1));
	}
	
	// Points sub-menu
	void PointsMenu(Bar& bar) {
		bar.Add("Get Point 1", THISBACK(GetP1));
		bar.Add("Get Point 2", THISBACK(GetP2));
		bar.Add("GoTo Point 1", THISBACK(GoToP1));
		bar.Add("GoTo Point 2", THISBACK(GoToP2));
	}
	void GetP1() {
        Point1<<= "35.037613,-117.968790";
        Angle2<<= 123.456;
//		PromptOK("GetP1 activated!");
	}
	void GetP2() {
        Point2<<= "35.037613,-117.968790";
//		PromptOK("GetP2 activated!");
	}
	void GoToP1() {
		PromptOK("GoToP1 activated!");
	}
	void GoToP2() {
		PromptOK("GoToP2 activated!");
	}
	
	// Calculate sub-menu
	void CalculateMenu(Bar& bar) {
		bar.Add("Distance", THISBACK(CalcDist));
		bar.Add("Point 2", THISBACK(CalcP2));
	}
	void CalcDist() {
		PromptOK("CalcDist activated!");
	}
	void CalcP2() {
		PromptOK("CalcP2 activated!");
	}

	// Exit menu handler
	void Exit() {
		if(PromptOKCancel("Exit MyApp?"))
			Break(); // Closes window with 'Cancel'
	}	
};

GUI_APP_MAIN
{
	MyApp().Run();
}
