#include "FixedArray.h"
// Enumeration for ArrayCtrl column indexes
enum : int {
	EDIT_X1 = 2,
	EDIT_VAL1,
	EDIT_TYPE1,
	EDIT_X2,
	EDIT_VAL2,
	EDIT_TYPE2
};

void FixedArray::InitializeLists()
{
	// Permanenti = Permanent, Vento = Wind, Neve = Snow
	// Pioggia = Rain, Ghiaccio = Ice
	cndDrop.Add("Permanent").Add("Wind").Add("Snow");

	for (int i = 0; i < typeCount; ++i)
		typeDrop.Add(i);
}

void FixedArray::ChangeEdits(const int cndIndex, const int typeIndex)
{
	x1Edit.Enable(), val1Edit.Enable();
	x2Edit.Enable(), val2Edit.Enable();

	if (cndIndex < 0 || typeIndex < 0) return;

	if (cndIndex == typeIndex)
	{
		x1Edit.Disable();
		x1Edit.SetData(Null);
	}
	else if (cndIndex > typeIndex)
	{
		x2Edit.Disable();
		x2Edit.SetData(Null);
	}
}

FixedArray::FixedArray()
{
	Title("Fixed ArrayCtrl test application");
	CenterScreen().MinimizeBox().MaximizeBox().Sizeable();
	SetRect(Size(640, 480));
	// Initialize drop lists with default data
	InitializeLists();
	// Configure drop lists and edit controls
	cndDrop.NotNull(); typeDrop.NotNull();
	x1Edit.NotNull().AlignRight(); val1Edit.NotNull().AlignRight();
	x2Edit.NotNull().AlignRight(); val2Edit.NotNull().AlignRight();
	// Configure events for controls
	list.WhenStartEdit = THISBACK(OnStartEdit);
	list.WhenSel = THISBACK(OnStatusChange);
	list.WhenUpdateRow = THISBACK(OnStatusChange);
	cndDrop.WhenAction = THISBACK(OnConditionTypeChange);
	typeDrop.WhenAction = THISBACK(OnConditionTypeChange);

	list.AutoHideSb().Appending().Inserting().Removing();
	// Initialize ArrayCtrl columns
	list.AddColumn("Condition").Edit(cndDrop).HeaderTab().SetAlign(ALIGN_CENTER);
	list.AddColumn("Type").Edit(typeDrop).HeaderTab().SetAlign(ALIGN_CENTER);
	list.AddColumn("x1 (cm)").Edit(x1Edit).SetConvert(valueConvert).HeaderTab().SetAlign(ALIGN_CENTER);
	list.AddColumn("Val1").Edit(val1Edit).SetConvert(valueConvert).HeaderTab().SetAlign(ALIGN_CENTER);
	list.AddColumn().SetConvert(typeConvert);
	list.AddColumn("x2 (cm)").Edit(x2Edit).SetConvert(valueConvert).HeaderTab().SetAlign(ALIGN_CENTER);
	list.AddColumn("Val2").Edit(val2Edit).SetConvert(valueConvert).HeaderTab().SetAlign(ALIGN_CENTER);
	list.AddColumn().SetConvert(typeConvert);
	// Get widths
	HeaderCtrl& hc = list.HeaderObject();
	const int textWidth = GetTextSize(val[1], Draw::GetStdFont()).cx,
		columnWidth = textWidth + hc.Tab(EDIT_TYPE1).GetMargin() * 2 + 1;
	hc.Tab(EDIT_TYPE1).Fixed(columnWidth); hc.Tab(EDIT_TYPE2).Fixed(columnWidth);
	// Configure status bar
	status.AddFrame(val2Info.Right(100)).AddFrame(x2Info.Right(100))
		.AddFrame(val1Info.Right(100)).AddFrame(x1Info.Right(100));
	// and info controls for default values
	status.Set(AttrText()); //OnStatusChange();
	x1Info.SetDefault(Null).Set(Null); val1Info.SetDefault(Null).Set(Null);
	x2Info.SetDefault(Null).Set(Null); val2Info.SetDefault(Null).Set(Null);

	Add(list.VSizePosZ(4, 4).HSizePosZ(4, 4));

	AddFrame(status);
	AddFrame(BottomSeparatorFrame());
}

void FixedArray::OnStartEdit()
{
	ChangeEdits(cndDrop.GetIndex(), typeDrop.GetIndex());
}

void FixedArray::OnConditionTypeChange()
{
	int index = list.GetCursor(),
		cndIndex = cndDrop.GetIndex(),
		typeIndex = typeDrop.GetIndex();

	if (index >= 0 && cndIndex >= 0 && typeIndex >= 0)
	{
		ChangeEdits(cndIndex, typeIndex);

		const String data(typeList[cndIndex][typeIndex]);
		list.Set(index, EDIT_TYPE1, data);
		list.Set(index, EDIT_TYPE2, data);
	}
}

void FixedArray::OnStatusChange()
{
	const int index = list.GetCursor();

	if (index >= 0)
	{
		const Value& x1 = list.Get(index, EDIT_X1), val1 = list.Get(index, EDIT_VAL1),
			x2 = list.Get(index, EDIT_X2), val2 = list.Get(index, EDIT_VAL2);

		x1Info.Set(x1.IsNull() ? Null : String().Cat() << x1 << " (cm)");
		val1Info.Set(val1.IsNull() ? Null : String().Cat() << val1 << " (" << list.Get(index, EDIT_TYPE1) << ')');
		x2Info.Set(x2.IsNull() ? Null : String().Cat() << x2 << " (cm)");
		val2Info.Set(val2.IsNull() ? Null : String().Cat() << val2 << " (" << list.Get(index, EDIT_TYPE2) << ')');
	}
}

GUI_APP_MAIN
{
	Ctrl::GlobalBackPaintHint();

	FixedArray().Run();
}
