#ifndef _FixedArray_FixedArray_h_
#define _FixedArray_FixedArray_h_

#include <CtrlLib/CtrlLib.h>

using namespace Upp;

const int cndCount = 3,
	typeCount = 3;

const String val[] = { "KN", "KN/cm", "KN/m" };
const String typeList[cndCount][typeCount] = {
	{ val[0], val[1], val[2] },
	{ val[2], val[0], val[1] },
	{ val[1], val[2], val[0] },
};

struct ValueConvert : public Convert {
	Value Format(const Value& q) const {
		if (IsVoid(q) || q.IsNull()) return AttrText().Paper(SColorFace());

		return AttrText(AsString(q)).Align(ALIGN_RIGHT);
	}
};

struct TypeConvert: public Convert {
	Value Format(const Value& q) const {
		AttrText data; data.Ink(SColorText()).Paper(SColorFace());
		if (IsVoid(q) || q.IsNull()) return data;

		return data.Set(AsString(q));
	}
};

class FixedArray : public TopWindow {
private:
	void InitializeLists();
	void ChangeEdits(const int cndIndex, const int typeIndex);
public:
	typedef FixedArray CLASSNAME;
	FixedArray();

	ArrayCtrl list;

	DropList cndDrop,
		typeDrop;
	
	ValueConvert valueConvert;
	TypeConvert typeConvert;

	EditInt x1Edit,	val1Edit,
		x2Edit,	val2Edit;
	
	InfoCtrl x1Info, val1Info,
		x2Info, val2Info;
	StatusBar status;

	void OnStartEdit();
	void OnConditionTypeChange();
	void OnStatusChange();
};

#endif
