#include "IPC.h"

IPC::~IPC(){
	StopServer();
}
void IPC::StartServer(){
	if(!ServerSocket(server, port)) {
		Cerr()<<"Unable to initialize server socket!\n"
		        "Another instance is probably in server mode already.\n";
		return;
	}
	serverThread.Run(THISBACK(Server));
}
void IPC::StopServer(){
	isServer=false;
	serverThread.Wait();
}
String IPC::Request(const String &msg){
	Socket client;
	if(!ClientSocket(client,"127.0.0.1",port)){
		StartServer();
		if(!ClientSocket(client,"127.0.0.1",port)){return Null;}
	}
	client.Write(msg + '\n');
	return Unescape(client.ReadUntil('\n'));
}
String IPC::Escape(const char* q) {
	String esc;
	for(;*q;q++) if(*q=='\n') esc.Cat("\\n"); else esc.Cat(*q);
	return esc;
}
String IPC::Unescape(const char* q){
	String unesc;
	for(;*q;q++) 
	    if((*q == '\\')&&(*(q+1)=='n')){unesc.Cat('\n');q++;}
		else unesc.Cat(*q);
	return unesc;
}
void IPC::Server(){
	isServer=true;
	for(;;) {
		if(!isServer) return;
		Socket s;
		if(server.Accept(s)) {
			String req = s.ReadUntil('\n');
			if(req.IsEmpty()) continue;
			else{
				String resp;
				WhenRequest(req,resp);
				s.Write(Escape(resp)+"\n");
			}
		}
	}
}
