#include <IPC/IPC.h>

struct App{
	typedef App CLASSNAME;
	Vector<String> list;
	
	void Show(String& req,String& resp){
		if(resp.IsEmpty()&&req=="show"){
			for(int i = 0; i < list.GetCount(); i++)
				resp+="\n"+list[i];
			resp=resp.Mid(1);
			if(resp.IsEmpty()) resp="List is empty";
		}
	}
	void Add(String& req,String& resp){
		if(resp.IsEmpty()&&req.StartsWith("add")){
			list.Add((req.GetLength()>4)?req.Mid(4):"");
			resp="Added \""+list.Top()+"\"";
		}
	}
	void Del(String& req,String& resp){
		if(resp.IsEmpty()&&req.StartsWith("del")){
			resp="Nothing deleted";
			String s=(req.GetLength()>4)?req.Mid(4):"";
			if(!s.IsEmpty()){
				int n=atoi(~s);
				if((n==0)&&(s.Find("0")<0)) return; //this is weak check, I know :-)
				if((n<0)||(n>=list.GetCount())) return;
				resp="Deleted \""+list[n]+"\"";
				list.Remove(n);
			}
		}
	}
	void Unknown(String& req,String& resp){
		if(resp.IsEmpty()) resp="Unknown command \""+req+"\"";
	}
	void Sync(IPC* ipc){
		String s=ipc->Request("show");
		int j=0;
		list.Clear();
		if(s=="List is empty") return;
		list.Add();
		for(int i = 0; i < s.GetCount(); i++){
			if(s[i]=='\n'){j++;list.Add();}
			else          {list[j]+=s[i];}
		}
	}
	
	void Run(){
		IPC ipc(3456);
		ipc.WhenRequest<<THISBACK(Add)
		               <<THISBACK(Del)
		               <<THISBACK(Show)
		               <<THISBACK(Unknown);
		Sync(&ipc);
		Cout()<<"$ ";
		for(String s=ReadStdIn();s!="quit";s=ReadStdIn()){
			Sync(&ipc);
			Cout()<<ipc.Request(s)<<"\n$ ";
		}
	}
};

CONSOLE_APP_MAIN{
	App().Run();
}