#include <IPC/IPC.h>

struct App{
	typedef App CLASSNAME;
	Vector<String> list;
	IPC2 ipc;

	App():ipc(3456){}

	void Show(String& req,String& resp){
		if(resp.IsEmpty()&&req=="show"){
			for(int i = 0; i < list.GetCount(); i++)
				resp+="\n"+list[i];
			resp=resp.Mid(1);
			if(resp.IsEmpty()) resp="List is empty";
		}
	}
	void Add(String& req,String& resp){
		if(resp.IsEmpty()&&req.StartsWith("add")){
			list.Add((req.GetLength()>4)?req.Mid(4):"");
			resp="Added \""+list.Top()+"\"";
		}
	}
	void Del(String& req,String& resp){
		if(resp.IsEmpty()&&req.StartsWith("del")){
			resp="Nothing deleted";
			String s=(req.GetLength()>4)?req.Mid(4):"";
			if(!s.IsEmpty()){
				int n=atoi(~s);
				if((n==0)&&(s.Find("0")<0)) return; //this is weak check, I know :-)
				if((n<0)||(n>=list.GetCount())) return;
				resp="Deleted \""+list[n]+"\"";
				list.Remove(n);
			}
		}
	}
	void Unknown(String& req,String& resp){
		if(resp.IsEmpty()) resp="Unknown command \""+req+"\"";
	}
	void Sync(){
		String s=ipc.Request("show");
		int j=0;
		list.Clear();
		if(s=="List is empty") return;
		list.Add();
		for(int i = 0; i < s.GetCount(); i++){
			if(s[i]=='\n'){j++;list.Add();}
			else          {list[j]+=s[i]; }
		}
	}
	void Echo(String& msg){
		if(msg.IsEmpty()) return;
		Cout()<<"\n*** Messagge received: \""<<msg<<"\" ***\n";
	}
	void Run(){
		ipc.WhenRequest<<THISBACK(Add)
		               <<THISBACK(Del)
		               <<THISBACK(Show)
		               <<THISBACK(Unknown);
		ipc.WhenMsg<<THISBACK(Echo);
		ipc.Broadcast("New client attached ("+AsString(ipc.GetId())+").");
		ipc.Send(ipc.GetServerId(),"\nHello Mr. Server!\nI'm here.\n  Yours "+AsString(ipc.GetId())+"\n");
		Sync();
		Cout()<<"$ ";
		for(String s=ReadStdIn();s!="quit";s=ReadStdIn()){
			Sync();
			Cout()<<ipc.Request(s)<<"\n$ ";
		}
		ipc.Broadcast("Client "+AsString(ipc.GetId())+" quits.");
	}
};

CONSOLE_APP_MAIN{
	App().Run();
}