#include "IPC.h"

IPC::~IPC(){
	StopServer();
}
void IPC::StartServer(){
	if(!ServerSocket(server, port)) {
		Cerr()<<"Unable to initialize server socket!\n"
		        "Another instance is probably in server mode already.\n";
		return;
	}
	serverThread.Run(THISBACK(Server));
}
void IPC::StopServer(){
	isServer=false;
	serverThread.Wait();
}
String IPC::Request(const String &msg){
	Socket client;
	if(!ClientSocket(client,"127.0.0.1",port)){
		StartServer();
		if(!ClientSocket(client,"127.0.0.1",port)){return Null;}
	}
	client.Write(Escape(msg)+'\n');
	return Unescape(client.ReadUntil('\n'));
}
String IPC::Escape(const char* q) {
	String esc;
	for(;*q;q++){
		if(*q=='\\') esc.Cat("\\\\"); 
		else if(*q=='\n') esc.Cat("\\n");
		else esc.Cat(*q);
	}
	return esc;
}
String IPC::Unescape(const char* q){
	String unesc;
	for(;*q;q++) if(*q == '\\'){
		if(*(q+1)=='n'){unesc.Cat('\n');q++;}
		else if(*(q+1)=='\\'){unesc.Cat('\\');q++;}
		else unesc.Cat(*q);
	}else unesc.Cat(*q);
	return unesc;
}
void IPC::Server(){
	isServer=true;
	for(;;) {
		if(!isServer) return;
		Socket s;
		if(server.Accept(s,0,true,500)) {
			String req = Unescape(s.ReadUntil('\n'));
			if(req.IsEmpty()) continue;
			else{
				String resp;
				WhenRequest(req,resp);
				s.Write(Escape(resp)+"\n");
			}
		}
	}
}

IPC2::IPC2(int port,int interval):IPC(port),interval(interval){
	WhenRequest=THISBACK(Protocol);
	id=atoi(Request("_register&"));
	Poll();
}
IPC2::~IPC2(){
	if(IsServer()){
		for(int j=0;j<20;j++){
			bool clean=true;
			for(int i=0;i<queue.GetCount();i++)
				if(!queue[i].IsEmpty()) clean=false;
			if(clean) break;
			Sleep(interval);
		}
	}else{
		int p=queue.Find(id);
		if(p>=0) for(int i=0;i<20;i++){
			if(queue[p].IsEmpty()) break;
			Sleep(interval);
		}
	}
	Request("_unegister&"+AsString(id));
}

void IPC2::Broadcast(String msg){
	Request("_broadcast&"+msg);
}
void IPC2::Send(int client_id,String msg){
	Request("_send-msg&"+AsString(client_id)+"&"+msg);
}
void IPC2::Poll(){
	Sync();
	String s=Request("_fetch&"+AsString(id));
	String t;
	for(int i = 0; i < s.GetCount(); i++){
		if(s[i]!='\n'){t.Cat(s[i]);} 
		else {
			if((t!="")&&(t!="NO_MSG")){
				t=Unescape(t);
				WhenMsg(t);
			}
			t.Clear();
		}
	}
	if((t!="")&&(t!="NO_MSG")){
		t=Unescape(t);
		WhenMsg(t);
	};
#ifndef flagGUI	
	timer.
#endif
	SetTimeCallback(interval,THISBACK(Poll));
}
void IPC2::Sync(){
	String s=Request("_sync&");
	int j=0;
	peers.Clear();
	if(s=="NO_PEERS"){LOG("weird,no peers found...");return;}
	String t;
	for(int i = 0; i < s.GetCount(); i++){
		if(IsDigit(s[i])){t.Cat(s[i]);} 
		else {
			if(t!="") peers.Add(atoi(t));
			t.Clear();
		}
	}
	if(t!="") peers.Add(atoi(t));
}
void IPC2::SendMsg(int client_id,String msg){
	int p=queue.Find(client_id);
	msg=Escape(msg);
	if(p>=0) queue[p]+=queue[p].IsEmpty()?msg:("\n"+msg);
	else queue.Add(client_id,msg);
}
void IPC2::Protocol(String& req,String& resp){
	if(req[0]!='_') return;
	if(req=="_sync&"){
		if(peers.GetCount()>0){
			resp=AsString(peers[0]);
			for(int i=1;i<peers.GetCount();i++){
				resp+=","+AsString(peers[i]);
			}
			return;
		}
		resp="NO_PEERS";
		return;
	}
	if(req.StartsWith("_fetch&")){
		int p=queue.Find(atoi(req.Mid(7)));
		if(p>=0){
			resp=queue[p];
			queue[p].Clear();
		}
		if(resp.IsEmpty()) resp="NO_MSG";
		return;
	}
	if(req.StartsWith("_send-msg&")){
		String msg=req.Mid(10);
		int p=msg.FindFirstOf("&");
		int i=peers.Find(atoi(msg.Left(p)));
		if(i>=0){
			SendMsg(peers[i],msg.Mid(p+1));
			resp="OK";
		}else{
			resp="ERROR";
		}
		return;
	}
	if(req.StartsWith("_broadcast&")){
		String msg=req.Mid(11);
		for(int i=0;i<peers.GetCount();i++) SendMsg(peers[i],msg);
		resp="OK";
		return;
	}
	if(req=="_server-id&"){
		resp=AsString(id);
		return;
	}
	if(req=="_register&"){
		int i;
		do{i=rand();}while(peers.Find(i)>=0);
		peers.Add(i);
		resp=AsString(i);
		return;
	}
	if(req=="_unregister&"){
		int i=atoi(req.Mid(12));
		int p=peers.Find(i);
		if(p>=0){
			peers.Remove(p);
			resp="OK";
		}
		resp="ERROR";
		return;
	}
}
int IPC2::GetId(){
	return id;
}
Vector<int> IPC2::GetClientIds(){
	Sync();
	return Vector<int>(peers.GetKeys(),1);
}
int IPC2::GetServerId(){
	return atoi(Request("_server-id&"));
}

