#ifndef _IPC_IPC_h_
#define _IPC_IPC_h_
#include <Web/Web.h>
#ifdef flagGUI
 #include <CtrlCore/CtrlCore.h>
#else
 #include <Timer/Timer.h>
#endif 
using namespace Upp;

class IPC{
public:
	typedef IPC CLASSNAME;
	Callback2<String&,String&> WhenRequest;

	IPC(int port=9876):port(port),isServer(false){}
	~IPC();
	String Request(const String &msg);
	void StartServer();
	void StopServer();
	bool IsServer(){return isServer;}
private:
	int port;
	bool isServer;
	Socket server;
	Thread serverThread;

	void Server();
protected:
	String Escape(const char* q);
	String Unescape(const char* q);
};

class IPC2:public IPC{
public:
	typedef IPC2 CLASSNAME;
	Callback1<String&> WhenMsg;

	IPC2(int port=9876,int interval=100);
	~IPC2();
	void Broadcast(String msg);
	void Send(int pclient_id,String msg);
	int GetId();
	Vector<int> GetClientIds();
	int GetServerId();
	
private:
	int interval,id;
	Index<int> peers;
	VectorMap<int,String> queue;
#ifndef flagGUI	
	Timer timer;  //requires Bazaar/Timer
#endif
	
	void Poll();
	void Sync();
	void SendMsg(int pclient_id,String msg);
	void Protocol(String& req,String& resp);
};
#endif
