namespace fileobj {

struct File
{
	File(const char* fname);
	~File();
	
	void Write(const char* text);
};

struct FileObject
{
	FileObject();
	
	bool IsOpened() const;
	void Close();
	void Open(const char* fname);
	void Write(const char* text);

private:	
	struct Impl;
public:
	
	struct Ref
	{
		Ref() {}
		Ref(FileObject file);
		
	    FileObject Get();
	private:
		weak_ptr<Impl> ref;
	};
	
private:
	FileObject(const shared_ptr<Impl>& impl);
	           
	struct Impl
	{
	    shared_ptr<File> file;
	    Mutex mutex;
	};
	
	shared_ptr<Impl> impl;
};

typedef StaticAutoLock<FileObject::Ref>::Access DataAccess;

void SetterThread();
void AccesserThread();

}


