template<typename T>
struct StaticAutoLock
{
	struct Access : private Mutex::Lock
	{
		Access() : Mutex::Lock(global.mutex)	{}
		
		T* operator->()							{ return &global.data; }
		T& operator*()							{ return global.data; }
	};
	
private:
	struct Static
	{
		Mutex mutex;
		T data;
	};
	
	static Static global;
};

template<typename T>
typename StaticAutoLock<T>::Static StaticAutoLock<T>::global;

