#ifndef _daireler_GameEngine_h_
#define _daireler_GameEngine_h_

#include <daireler/daire.h>

#define DAIRE_RADIUS 30

bool dizideBul(Array<SeciliDaire> &dizi, SeciliDaire &d);

class GameEngine
{
private:
	Array<Array<Daire> > daireList;
	
	int maxRow, maxCol;
	
	int score;
	
	void aynilariBul(Array<SeciliDaire> &bulunanlar, int row, int col, Renkler color);
	void yoket(Array<SeciliDaire> &bulunanlar);
	void kolonKaydir(Array<int> &kolonlar);	
	
	void daireleriYarat();
	
public:
	GameEngine(Size viewportSize);
	
	void yoketKontrolu(SeciliDaire secili);
	Array<Array<Daire> >& getDiareList();
	int getScore();
};

#endif
