#include "GameEngine.h"

// Find in array

bool dizideBul(Array<SeciliDaire> &dizi, SeciliDaire &d)
{
	bool var = false;
	for(int i=0; i<dizi.GetCount(); i++)
	{
		if(dizi[i] == d)
		{
			var = true;
			break;
		}
	}
	return var;
}

GameEngine::GameEngine(Size viewportSize)
{
	maxCol = viewportSize.cx/(DAIRE_RADIUS + 1);
	maxRow = viewportSize.cy/(DAIRE_RADIUS + 1);
	
	score = 0;
	
	daireleriYarat();
}

// Create balls

void GameEngine::daireleriYarat()
{
	int random=0;
	for(int row=0; row<maxRow; row++)
	{
		Array<Daire> &daireRow = daireList.Add();
		for(int col=0; col<maxCol; col++)
		{
			random = Random()%4;
			Daire &d = daireRow.Add(new Daire((Renkler)random));
		}
	}
}

// When user click on a ball. This method find same color balls.

void GameEngine::aynilariBul(Array<SeciliDaire> &bulunanlar,
						     int row, int col,
						     Renkler color)
{
	int t, r, b, l;
	
	t = (row-1 >= 0) ? row-1 : -1;
	r = (col+1 < maxCol) ? col+1 : -1;
	b = (row+1 < maxRow) ? row+1 : -1;
	l = (col-1 >= 0) ? col-1 : -1;
	
	if(t >= 0)
	{
		if(daireList[t][col].getRenk() == color && !daireList[t][col].getSpace())
		{
			SeciliDaire d;
			d.col = col;
			d.row = t;
			
			if(!dizideBul(bulunanlar, d))
			{
				bulunanlar.Add(d);
				aynilariBul(bulunanlar, t, col, color);
			}
		}
	}
	if(r >= 0)
	{
		if(daireList[row][r].getRenk() == color && !daireList[row][r].getSpace())
		{
			SeciliDaire d;
			d.col = r;
			d.row = row;
			
			if(!dizideBul(bulunanlar, d))
			{
				bulunanlar.Add(d);
				aynilariBul(bulunanlar, row, r, color);
			}
		}
	}
	if(b >= 0)
	{
		if(daireList[b][col].getRenk() == color && !daireList[b][col].getSpace())
		{
			SeciliDaire d;
			d.col = col;
			d.row = b;
			
			if(!dizideBul(bulunanlar, d))
			{
				bulunanlar.Add(d);
				aynilariBul(bulunanlar, b, col, color);
			}
		}
	}
	if(l >= 0)
	{
		if(daireList[row][l].getRenk() == color && !daireList[row][l].getSpace())
		{
			SeciliDaire d;
			d.col = l;
			d.row = row;
			
			if(!dizideBul(bulunanlar, d))
			{
				bulunanlar.Add(d);
				aynilariBul(bulunanlar, row, l, color);
			}
		}
	}
}

// When user click on a ball. it will find same balls. and this method destroying balls

void GameEngine::yoket(Array<SeciliDaire> &bulunanlar)
{
	Array<int> cols;
	Array<int> bosKolonlar;
		
	for(int i=0; i<bulunanlar.GetCount(); i++)
	{
		bool islenmis = false;

		for(int col=0; col<cols.GetCount(); col++)
		{
			if(bulunanlar[i].col == cols[col])
			{
				islenmis = true;
				break;
			}
		}
		if(!islenmis)
		{
			int col=bulunanlar[i].col;
			cols.Add(col);
			
			bool doluKolon = false;
			
			for(int k=0; k<daireList.GetCount(); k++)
			{
				if(daireList[k][col].getSpace())
				{					
					for(int l=0; l<k; l++)
					{
						Daire ust = daireList[k-(l+1)][col];
						Daire suan = daireList[k-l][col];
						
						daireList[k-(l+1)][col] = suan;
						daireList[k-l][col] = ust;
					}
				}
				else
				{
					doluKolon = true;
				}
			}
			
			if(!doluKolon)
			{
				bosKolonlar.Add(col);
			}
		}
	}
	
	if(!bulunanlar.IsEmpty())
		kolonKaydir(bosKolonlar);
}

// if a colon is empty move to right 

void GameEngine::kolonKaydir(Array<int> &kolonlar)
{
	Sort(kolonlar);
	for(int a=0; a<kolonlar.GetCount(); a++)
	{
		int col = kolonlar[a];
		int colDistance = daireList[0].GetCount() - (col + 1);
		for(int i=0; i<daireList.GetCount(); i++)
		{
			for(int j=0; j<colDistance; j++)
			{
				Daire sag = daireList[i][col+(j+1)];
				Daire suan = daireList[i][col+j];

				daireList[i][col+j] = sag;
				daireList[i][col+(j+1)] = suan;
			}		
		}
		for(int i=a+1; i<kolonlar.GetCount(); i++)
			kolonlar[i] -= 1;
	}
}

// GameViewports LeftDown method calling this method for finding and destroying balls

void GameEngine::yoketKontrolu(SeciliDaire secili)
{
	Array<SeciliDaire> aynilar;
	
	if(daireList[secili.row][secili.col].getSpace())
		return;
	
	else
	{
		aynilariBul(aynilar, secili.row, secili.col, daireList[secili.row][secili.col].getRenk());
		
		if(!aynilar.IsEmpty())
		{
			aynilar.Add(secili);	
			SeciliDaire tmp;
			
			for(int i=0; i<aynilar.GetCount(); i++)
			{
				tmp = aynilar[i];
				daireList[tmp.row][tmp.col].setSpace(true);
			}		
			
			yoket(aynilar);
			score += (1.5 * aynilar.GetCount()) * (25*aynilar.GetCount());
		}
	}
}

// return balls list.

Array<Array<Daire> >& GameEngine::getDiareList()
{
	return daireList;
}

int GameEngine::getScore()
{
	return score;
}

