#include "GameViewport.h"

#define IMAGECLASS MyImagesViewport
#define IMAGEFILE  <daireler/viewport_images.iml>
#include <Draw/iml.h>

GameViewport::GameViewport()
{
	secili.col = -1;
	secili.row = -1;
	
	BackPaint();
}

void GameViewport::SetGameEngine(GameEngine &gEngine)
{
	this->gEngine = &gEngine;
	Refresh();
}

void GameViewport::Paint(Draw &g)
{
	g.DrawRect(0,0,GetSize().cx, GetSize().cy, White);
	Array<Array<Daire> > &daireList = gEngine->getDiareList();
	for(int i=0; i<daireList.GetCount(); i++)
	{
		for(int j=0; j<daireList[i].GetCount(); j++)
		{
			if(!daireList[i][j].getSpace())
			{
				Rect rect;

				rect.left = j * (DAIRE_RADIUS + 1);
				rect.right = (j * (DAIRE_RADIUS + 1)) + DAIRE_RADIUS;
				rect.top = i * (DAIRE_RADIUS + 1);
				rect.bottom = i * (DAIRE_RADIUS + 1) + DAIRE_RADIUS;
				
				if(daireList[i][j].getRenk() == KIRMIZI)
					g.DrawImage(rect, MyImagesViewport::kirmizi());
				else if(daireList[i][j].getRenk() == YESIL)
					g.DrawImage(rect, MyImagesViewport::yesil());
				else if(daireList[i][j].getRenk() == MAVI)
					g.DrawImage(rect, MyImagesViewport::mavi());
				else if(daireList[i][j].getRenk() == BEYAZ)
					g.DrawImage(rect, MyImagesViewport::beyaz());
			}
		}
	}
}

void GameViewport::MouseMove(Point p, dword keyflags)
{
	int row, col;
	
	row = p.y / (DAIRE_RADIUS + 1);
	col = p.x / (DAIRE_RADIUS + 1);
	
	SeciliDaire daire;
	daire.col = col;
	daire.row = row;
	
	if(secili == daire)
		return;
	else
		secili = daire;
}

void GameViewport::LeftDown(Point p, dword keyflags)
{
	if(secili.row != -1 && secili.col != -1)
		gEngine->yoketKontrolu(secili);
	PromptOK("Abooov");
	Refresh();
}