#include "Style.h"
#include "Helpers.h"

NAMESPACE_UPP


void SvgStyle::Get(String str) {
	String value;
	Color color;
	
	color = GetColorXml(GetValueStringXml(str, "stroke:"));
	if (!color.IsNullInstance())
		stroke = color;
	
	value = GetValueStringXml(str, "stroke-width:");
	if (value != "")
		strokeWidth = atoi(value);
	
	color = GetColorXml(GetValueStringXml(str, "fill:"));
	if (!color.IsNullInstance())
		fill = color;
	
	value = GetValueStringXml(str, "opacity:");
	if (value != "")
		strokeOpacity = atof(value);
}

SvgStyle& SvgStyle::operator=(const SvgStyle &style) {
	if (this == &style)      // Same object?
  		return *this; 
	stroke = style.stroke;
	fill = style.fill;
	fillOpacity = style.fillOpacity;
	fillStyleEvenOdd = style.fillStyleEvenOdd;
	strokeOpacity = style.strokeOpacity;
	strokeWidth = style.strokeWidth;
	fontFamily = style.fontFamily;
	fontSize = style.fontSize;
	fontStyle = style.fontStyle;
	anchor = style.anchor;
	audio = style.audio;
	color = style.color;
	display = style.display;
	return *this;
}

void SvgStyle::Apply(Painter &sw) {		
	if (!fill.IsNullInstance()) {
		sw.EvenOdd(fillStyleEvenOdd);
		sw.Opacity(fillOpacity);	
		sw.Fill(fill);
	}
	if (!stroke.IsNullInstance()) {
		sw.Opacity(strokeOpacity);
		sw.Stroke(strokeWidth, stroke);
	}
}

END_UPP_NAMESPACE