#ifndef _PainterSvg_Style_h_
#define _PainterSvg_Style_h_

#include "PainterSvg.h"

NAMESPACE_UPP

namespace SVG {

enum Display {
	dsNone,
	dsInline,
	dsBlock,
};

enum FontStyle {
	fsNormal,
	fsItalic,
	fsOblique,
};

}

class SvgStyle {
public:
	SvgStyle() {
		strokeWidth = 1;
		fill = Black;
		stroke = Null;
		strokeOpacity = 1;
		fillOpacity = 1;
		fillStyleEvenOdd = true;
		fontFamily = Font::ARIAL;
		fontSize = 12;
		fontStyle = SVG::fsNormal;
		anchor = 0;
		audio = 1.0;
		display = SVG::dsInline;
		color = Black();
	}
	
	SvgStyle(SvgStyle &transf) {
		*this = transf;
	}
	
	void Get(String str);	
	void Apply(Painter &sw);	
	SvgStyle &operator=(const SvgStyle &style);
	
public:
	double strokeWidth;
	Color fill;
	double fillOpacity;
	Color stroke;
	double strokeOpacity;
	int fontFamily;
	double fontSize;
	SVG::FontStyle fontStyle;
	int anchor;
	double audio;
	Color color;
	bool fillStyleEvenOdd;
	SVG::Display display;
};

END_UPP_NAMESPACE

#endif
