#ifndef _PainterSvg_Transform_h_
#define _PainterSvg_Transform_h_

#include "PainterSvg.h"

NAMESPACE_UPP

class Svg2DTransform {
public:
	Svg2DTransform() {
		transX = transY = 0;
		angle = 0;
		scaleX = scaleY = 1;
	}
	
	Svg2DTransform(Svg2DTransform &transf) {
		*this = transf;
	}
	
	void Apply(Painter &sw)	{
		sw.End();
		sw.Begin();
		sw.Translate(transX, transY);
		sw.Scale(scaleX, scaleY);
		sw.Rotate(angle);
	}
	
	void Translate(double x, double y) {
		transX += x;
		transY += y;
	}
	
	void Scale(double x, double y) {
		scaleX *= x;
		scaleY *= y;
	}
	
	void Rotate(double ang)	{
		angle += ang;
	}
	
	Svg2DTransform &operator=(const Svg2DTransform &transf)	{
		if (this == &transf)      // Same object?
      		return *this; 
		transX = transf.transX;
		transY = transf.transY;
		angle = transf.angle;
		scaleX = transf.scaleX;
		scaleY = transf.scaleY;
		return *this;
	}
	
private:
	double transX;
	double transY;
	double angle;
	double scaleX;
	double scaleY;
};

END_UPP_NAMESPACE

#endif
