#ifndef _CachedData_CachedCtrl_h_
#define _CachedData_CachedCtrl_h_

NAMESPACE_UPP

template <class T>
class CachedCtrl : public T {
private:
	Value value;
	bool changed;
public:
	CachedCtrl() : changed(false) { }
	Callback operator<<=(Callback action) { return T::operator<<=(action); }
	void operator<<=(const Value& data) { changed = true; value = data; }
	virtual void SetData(const Value& data) { changed = true; value = data; }
	virtual Value GetData() const { return value; }
	Value operator~() const { return value; }
	virtual void Apply() { if (changed) T::SetData(value); }
	virtual bool IsChanged() const { return changed; }
};

END_UPP_NAMESPACE

#endif
