#include "App.h"

App::App()
{
	Title("Cached data test application");
	CenterScreen().Sizeable().MinimizeBox().MaximizeBox();
	SetRect(Size(640, 480));

	WhenClose = THISBACK(OnExit);

	split.SetPos(5000);
	normalData.SetFrame(RightSeparatorFrame());
	cachedData.SetFrame(LeftSeparatorFrame());
	split.Horz(normalData.SizePos(), cachedData.SizePos());
	Add(split);
}

void App::OnExit()
{
	split.Hide();
	Close();
}

bool App::Key(dword key, int count)
{
	if (key == K_F5)
	{
		const Point mousePos = GetMousePos();
		const dword mouseFlags = GetMouseFlags();

		if (normalData.IsDoing()) normalData.LeftDown(mousePos, mouseFlags);
		else normalData.RightDown(mousePos, mouseFlags);

		return true;
	}
	else if (key == K_F6)
	{
		const Point mousePos = GetMousePos();
		const dword mouseFlags = GetMouseFlags();
		
		if (cachedData.IsDoing()) cachedData.LeftDown(mousePos, mouseFlags);
		else cachedData.RightDown(mousePos, mouseFlags);

		return true;
	}
#ifdef COMPILER_MSC
	else if (key == K_F7)
	{
		const int duration = 10000,	gap = 1000; // ms

		SetTimeCallback(0, THISBACK2(Key, K_F5, 1));
		SetTimeCallback(duration, THISBACK2(Key, K_F5, 1));
		SetTimeCallback(duration + gap, THISBACK2(Key, K_F6, 1));
		SetTimeCallback(2 * duration + gap, THISBACK2(Key, K_F6, 1));

		return true;
	}
#endif
	else return TopWindow::Key(key, count);
}

GUI_APP_MAIN
{
	Ctrl::GlobalBackPaint();

	App app;
	app.Run();
}
